/**
 * AvertaVisualSelector v1.1
 * An jQuery for making elements selectable
 * Copyright (c) averta | http://averta.net | 2013.06
 * licensed under the MIT license
 **/


if(typeof Object.create !== 'function' ){ Object.create = function (obj){ function F(){}; F.prototype = obj; return new F(); }; };
;(function($){
    
    var SelectionList = {
        
        init : function(el, options){
            //cache this
            var self        = this;
            self.options    = $.extend({},$.fn.avertaVisualSelector.defaultOptions, options || {} );
            
            // Access to jQuery and DOM versions of element
            self.$el        = $(el);
            self.el         = el;
            
            self.setup();
        },
        
        setup: function(){
            var self = this;
            var $itemsWrapper, $itemWrapper;
            
            // get list of options from select dom
            self.$options  = self.$el.find('option');
            
            // create the main wrapper and wrap select element
            var $container = $('<' + self.options.containerElement + ' />').attr({ 'class': self.options.containerClass });
            self.$el.wrap($container);
            self.$container = self.$el.parent();
            
            var $toggle = $('<a />').attr({ "class":"button "+self.options.toggleBtnClass, "href":"#" }).text(self.options.toggleBtnLabel);
            self.$container.append($toggle);
            $toggle = self.$container.children(".button");
            
            // create a container for visual elements and append to main wrapper
            var $itemsWrapper = $('<' + self.options.itemsWrapper + ' />').addClass(self.options.itemsWrapperClass);
            $itemsWrapper.appendTo(self.$container);
            self.$itemsWrapper = self.$container.children(self.options.itemsWrapper);
            
            
            $toggle.on("click", function(e){
               e.preventDefault();
               self.$itemsWrapper.slideToggle(600, "easeOutQuart"); 
            });
            
            
            // get dropdown default value
            var defaultValue = self.$el.attr("data");
            
            //loop through dropdown options and build visual selector list
            self.$options.each(function(index) {
                var $this   = $(this); 
                
                // get option value
                var attr = $this.attr("value");                    
                if(!attr) return true;
                
                // create a visual element
                $itemWrapper = $('<' + self.options.itemWrapper + ' />', 
                                            { 'class': self.options.itemWrapperClass })
                                            .append($('<i />', {'class': attr+" icon-2x", 'data-name':attr, 'title':attr.substring(5) }))
                                            .on('click', {'self':self}, self.onView_clicked);
                
                // mark it as selected if it's already selected in dropdown
                if(defaultValue == attr) $itemWrapper.addClass(self.options.selectedClass);
                
                // append it to elements wrapper
                $itemWrapper.appendTo(self.$itemsWrapper);
            });
            
            // whenever dropdown value changed manualy, update visual list too
            self.$el.on("change", {'self':self}, self.onDropdown_changed);
        },
        
        onView_clicked:function(event){
            var self = event.data.self;
            var $el  = $(this);
            var val  = $el.children("i").attr("data-name");
            
            // update dropdown value, when visual element selected
            self.$el.val(val);
            
            if(self.options.multiSelection == 'false'){
                //single selection
                $el.siblings().removeClass(self.options.selectedClass).end()
                   .addClass(self.options.selectedClass);
            }else{
                //multi selection
                $el.addClass(self.options.selectedClass);
            }
        },
        
        onDropdown_changed:function(event){
            var self = event.data.self;
            var $el  = $(this);
            self.$itemsWrapper
                    .find("li").removeClass(self.options.selectedClass)
                        .find("i." + $el.val())
                    .parent()
                        .addClass(self.options.selectedClass);
        }
    };
    
    
    
     $.fn.avertaVisualSelector = function(options){
        return this.each(function(){
            var sl = Object.create(SelectionList);
            sl.init(this, options);
        });
    };
    
    $.fn.avertaVisualSelector.defaultOptions = {
        multiSelection:   'true',           // Enables multi item selection. Default is true 
        selectedClass:    'selected',       // The css class that adds to selected item
        containerElement: 'div',            // The main dom that will be generated and wraps all elements.Default is 'div'
        containerClass:   'axi-vs-container',//The css class that adds to main container
        itemsWrapper:     'ul',             // A dom that will be generated and wraps all elements wrappers.Default is 'ul'
        itemsWrapperClass:'selection-list', // The css class that adds to items wrapper
        itemWrapper:      'li',             // A dom that will be generated , and waps each input element.Default is 'li'
        itemWrapperClass: '',               // The css class that adds to each item wrapper
        toggleBtnClass:   'vs-btn-toggle',
        toggleBtnLabel:   'Toggle Visual Selector'
    };
    
})(jQuery);
