<?php 
    global $axiom_options, $axi_img_size; 
    $axi_layout = axiom_get_page_sidebar_pos($post->ID);
    
    $size  = ( $axi_layout != 'no-sidebar' ) ? $axi_img_size['side'] : $axi_img_size['full'];





    // get portfolio custom meta values ///////////////////////////////////////////////////////

    $the_metas = '';

    // get label and value of custom product datas
    for ($i=1; $i <= 9; $i++) {
        // get labels from theme options
        if( ! isset( $axiom_options['portfolio_custom_meta_label'.$i] ) ) continue;
            $meta_label = make_clickable( $axiom_options['portfolio_custom_meta_label'.$i] ) ;
        if( empty( $meta_label ) ) continue;
        
        // get portfolio meta values and print
        $meta_val = get_post_meta($post->ID, 'axi_portfolio_custom_data'.$i, true);
        if( empty( $meta_val ) ) continue;
        $the_metas .= sprintf('<li><strong>%s : </strong>%s', make_clickable( $meta_label ), do_shortcode( $meta_val ) );
    }
    
    $project_link  = get_post_meta($post->ID, 'project-link', true);
    
    if( ! empty( $project_link ) ){
        $project_label = get_post_meta( $post->ID, 'project-link-label', true );
        $project_label = ! empty( $project_label ) ? $project_label : $project_link;
        $the_metas .= sprintf( '<li><strong>%s : </strong><a href="%s" target="_blank">%s</a></li>', __("Project's Link", 'default'), $project_link, $project_label );
    }



    // fetch portfolio images //////////////////////////////////////////////////////////////////
                                            
    // get images display type
    $display_type = get_post_meta($post->ID, "display_type", true);
    
    $slider       = "";
    $live_img_url = ""; // stores one available image url
    $live_vid_url = ""; // stores one available video url
    $imageNums    = 0 ; // stores the number of images in slider
    $videoNums    = 0 ; // stores the number of videos in slider

    $the_media = '';
    
    // if display type is flex slider
    if($display_type == "flexslider1" || $display_type == "flexslider2"){
        
        $flexslider_effect = ($display_type == "flexslider1")?"fade":"slide";
        
        // get all image links and print flexslider shortcode
        $slider  = '[flexslider slideshow="no" effect="'.$flexslider_effect.'" smooth_height="yes" ]';
        
        for ($i=1; $i <= 3; $i++) { 
            $vid_url = get_post_meta($post->ID, "axi_vimeo_link".$i, true);
            if(!empty($vid_url)){
                ++$videoNums;
                $live_vid_url = $vid_url;
                $slider .= '[simple_slide video="'.$vid_url.'"  ][/simple_slide]';
            }
        }
        
        for ($i=1; $i <= 12; $i++) { 
            $img_url = get_post_meta($post->ID, "axi_custom_image".$i, true);
            
            if(!empty($img_url)){
                ++$imageNums;
                $img_url      = axiom_get_the_absolute_image_url($img_url);
                $live_img_url = axiom_get_the_resized_image_src($img_url, $size[0], $size[1], true );
                $img_caption  = get_post_meta($post->ID, "axi_custom_image".$i."_caption", true);
                $slider .= '[simple_slide src="'.$live_img_url.'" alt="'.$img_caption.'" ]'.$img_caption.'[/simple_slide]';
            }
        }
        
        $slider    .= '[/flexslider]';
        $the_media .= do_shortcode( $slider );
    
    // if display type is nivo slider
    }elseif($display_type == "nivoslider"){
        
        // get all image links and print nivoslider shortcode
        $slider  = '[nivoslider ]';
        for ($i=1; $i <= 12; $i++) { 
            $img_url = get_post_meta($post->ID, "axi_custom_image".$i, true);
            if(!empty($img_url)){
                ++$imageNums;
                $img_url      = axiom_get_the_absolute_image_url($img_url);
                $live_img_url = axiom_get_the_resized_image_src($img_url, $size[0], $size[1], true );
                $img_caption  = get_post_meta($post->ID, "axi_custom_image".$i."_caption", true);
                $slider .= '[nivo_slide src="'.$live_img_url.'" alt="'.$img_caption.'" ]'.$img_caption.'[/nivo_slide]';
            }
        }
        
        $slider    .= '[/nivoslider]';
        $the_media .= do_shortcode( $slider );
    
    // if display type is regular
    }else{
        // output the videos 
        for ($i=1; $i <= 3; $i++) { 
            $vid_url = get_post_meta($post->ID, "axi_vimeo_link".$i, true);
            if(!empty($vid_url)){
                ++$videoNums;
                $the_media .= do_shortcode('[video_element url="'.$vid_url.'" full="yes" ]').'<div class="hbar"></div>';
            }
        }

        // output the images
        for ($i=1; $i <= 12; $i++) { 
            $img_url = get_post_meta($post->ID, "axi_custom_image".$i, true);
            if(!empty($img_url)){
                ++$imageNums;
                $img_url = axiom_get_the_absolute_image_url($img_url);
                if(axiom_contains_upload_dir($img_url))
                    $img_url = axiom_get_the_resized_image_src($img_url, $size[0], $size[1], true );
                $img_caption     = get_post_meta($post->ID, "axi_custom_image".$i."_caption", true);
                $img_caption_tag = !empty($img_caption)?'<p class="single-image-caption" >'.$img_caption.'</p>':"";
                $the_media .= '<div class="imgHolder" ><img src="'.$img_url.'" alt="'.$img_caption.'" />'.$img_caption_tag.'</div><div class="hbar"></div>';
            }
        }
        
    }
    
    
    if($imageNums == 1 && $videoNums == 0){ // if there is a single image, do not display slider
        $the_media = '<div class="imgHolder" ><img src="'.$live_img_url.'" alt="'.get_the_title().'" /></div>';
    } elseif ($videoNums == 1 && $imageNums == 0) {
        $the_media = do_shortcode('[axi-video-embed url="'.$live_vid_url.'" full="yes" ]');
    } elseif ($videoNums == 0 && $imageNums == 0) { //echo $slider;
        $the_media = '';
    }

    // return if media or meta is not set //////////////////////////////////////////////////////////////////

    $overview_content = get_the_content();

    if( empty( $the_media ) && empty( $the_meta ) && empty( $overview_content ) )
        return;
?>


                            <article <?php post_class(axiom_get_page_layout($post->ID) );?> >                                
                                
                                
                                <div class="entry-wrapper">
                                    
                                    <div class="entry-media">
                                        
                                            <?php echo $the_media; ?>
                                        
                                    </div><!-- media-content -->
                                    
                                    <div class="entry-content">
                                        <?php 
                                        
                                        if( ! empty( $overview_content) ) { ?>
                                        <div class="overview">
                                            <h5><?php _e("Overview", "default"); ?></h5>
                                            <?php echo make_clickable( do_shortcode( $overview_content ) ); ?>
                                        </div>
                                        <?php } unset( $overview_content ); ?>
                                        
                                        <div class="single-info">
                                            <div class="sep hbar"> </div>

                                            <ul class="meta-folio">
                                                <?php echo $the_metas; ?>
                                            </ul>
                                            
                                        <?php if(isset($axiom_options["portfolio_show_share_btns"])){ ?>
                                            <ul class="socials">
                                                <li><a href="http://www.facebook.com/sharer.php?u=<?php echo urlencode(get_permalink()); ?>" class="icon-facebook-sign" title="<?php _e("Share on facebook","default"); ?>" target="_blank" > </a>
                                                <li><a href="http://www.twitter.com/share?url=<?php echo urlencode(get_permalink()); ?>" class="icon-twitter" title="<?php _e("Share on twitter","default"); ?>" target="_blank" > </a>
                                                <li><a href="https://plus.google.com/share?url=<?php echo urlencode(get_permalink()); ?>" class="icon-google-plus-sign" title="<?php _e("Share on google plus","default"); ?>" target="_blank" > </a>
                                        <?php $pin_image = av3_get_the_attachment_url($post->ID, "full"); ?>
                                                <li><a href="http://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink()); ?>&media=<?php echo urlencode($pin_image); ?>&description=<?php the_title(); ?>" class="icon-pinterest-sign" title="<?php _e("Share on pinterest","default"); ?>" target="_blank" ></a></li>
                                                <li><a href="javascript:void(0);" onclick="javascript:emailThisPage(); return false;" class="icon-envelope-alt" title="<?php _e("Email this","default"); ?>" target="_blank" > </a>
                                            </ul>
                                            <script language="javascript">
                                                function emailThisPage(){
                                                    window.location.href="mailto:?subject="+document.title+"&body="+escape(window.location.href);
                                                }
                                            </script>
                                        <?php } ?>
                                        </div>
                                        
                                        
                                    </div><!-- entry-content -->
                                    
                                    
                                </div><!-- entry-wrapper -->
                                
                            </article><!-- widget-container -->