
/*=======================================================================================
 *	On Document Ready
 *======================================================================================*/

jQuery(document).ready(function($) {
	
	init_plugins();
	
	// select default option, on select dom
	$('select.meta-select').each(function(index) { var $this = $(this); if($this.attr('data')) $this.val( $this.attr('data') ); });
});


////// init plugins //////////////////////////////////////////////////

function init_plugins() {
	var $ = jQuery.noConflict();
	
	dir = axiom.themeurl + '/axiom/css/images/elements/empty.png';
	$('.av3_container input[type="checkbox"]:not([safari][data-src])').checkbox({ empty: dir});
	
	jQuery('[type="range"]').avertaRangeControl();
	jQuery('input, textarea' ).placeholder();
	jQuery('.selection-list-wrap').avertaPrettySelector({ multiSelection:'false'});
	jQuery('.av3_option_panel').avertaLiveTabs({
		enableHash:      true ,
        updateHash:      true
	});
	
	$('.sortbox').sortable({
		connectWith:'.draggable-area ul',
		helper:'clone',
		placeholder:'sort-item-heighlight',
		opacity:1,
		revert: true
	});
	
	$(".axi-icon-list").avertaVisualSelector({
        itemsWrapperClass: 'selection-list axi-icon-list',
        multiSelection:    'false',
        toggleBtnClass:    'vs-btn-toggle yellow',
        containerClass:    'axi-vs-container icon-vs-container',
        toggleBtnLabel:   'Toggle Visual Icon Selector'
    });
    
    // initialize WordPress color picker on text input field
    if( typeof jQuery.wp === 'object' && typeof jQuery.wp.wpColorPicker === 'function' ){
        jQuery('.mini-color-wrapper input[type="text"]').wpColorPicker();
    }

    // init date fields if exist
    $date_fields = $('input#custom_news_date');
    if($date_fields.length) {
		$date_fields.datepicker({
			dateFormat:'yy-mm-dd'
		});
    }
}


//////////////////////////////////////////////////////////////////////

    





