<?php
/**
 * Defining Constants.
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.1
 * @link       http://www.averta.net
 */
 
/*-----------------------------------------------------------------------------------*/
/*  Define Global Vars
/*-----------------------------------------------------------------------------------*/

// core version
if(! defined('AXIOM_VERSION') ) define( 'AXIOM_VERSION', '2.0'             );

// domain name for tranlation file
if(! defined('THEME_DOMAIN')  ) define('THEME_DOMAIN'  , 'default'         );




// Server path for current theme directory
if(! defined('THEME_DIR')      ) define('THEME_DIR'   , get_template_directory().'/'     );

// Http url of current theme directory
if(! defined('THEME_URL')      ) define('THEME_URL'   , get_template_directory_uri().'/' );




// Server path for theme inc directory
if(! defined('THEME_INC_DIR')  ) define('THEME_INC_DIR', THEME_DIR. 'inc/'   );

// Http url of theme inc directory
if(! defined('THEME_INC_URL')  ) define('THEME_INC_URL', THEME_URL. 'inc/'  );





// Server path for admin folder
if(! defined('AXI_DIR')       ) define('AXI_DIR'      , THEME_DIR. 'axiom/'      );

// Http url of admin folder
if(! defined('AXI_URL')       ) define('AXI_URL'      , THEME_URL. 'axiom/'      );




// Server path for admin > include folder
if(! defined('AXI_INC')       ) define('AXI_INC'      , AXI_DIR. 'axi-include/'  );

// Http url of admin > include folder
if(! defined('AXI_INC_URL')   ) define('AXI_INC_URL'  , AXI_URL. 'axi-include/'  );




// Server path for admin > include folder
if(! defined('AXI_CON')       ) define('AXI_CON'      , AXI_DIR. 'axi-content/'  );

// Http url of admin > include folder
if(! defined('AXI_CON_URL')   ) define('AXI_CON_URL'  , AXI_URL. 'axi-content/'  );




// Server path for admin > css folder
if(! defined('ADMIN_CSS')     ) define('ADMIN_CSS'    , AXI_DIR. 'css/'      );

// Http url of admin > css folder
if(! defined('ADMIN_CSS_URL') ) define('ADMIN_CSS_URL', AXI_URL. 'css/'      );




// Server path for admin > js folder
if(! defined('ADMIN_JS')      ) define('ADMIN_JS'     , AXI_DIR. 'js/'       );

// Http url of admin > js folder
if(! defined('ADMIN_JS_URL')  ) define('ADMIN_JS_URL' , AXI_URL. 'js/'       );





// include theme custom constants
require_once(AXI_CON. 'init/const.php');




// theme name
$theme_data = wp_get_theme();
if(! defined('THEME_NAME')       ) define('THEME_NAME'       ,  $theme_data->Name    );
if(! defined('THEME_NAME_I18N')  ) define('THEME_NAME_I18N'  ,  __( $theme_data->Name, THEME_DOMAIN ) );
if(! defined('THEME_VERSION')    ) define('THEME_VERSION'    ,  $theme_data->Version );


// this id is used as prefix in database option field names - specific for each theme
if(! defined('THEME_ID')      ) define('THEME_ID'      ,  "axiom_skeleton" );


// To display or hide support information in help panel
if( !defined('AXIOM_SUPPORT') ) define('AXIOM_SUPPORT' , true );


if( !defined('AXIOM_NO_BRAND')) define('AXIOM_NO_BRAND', false );


// set this to false to disable update notifier
if( !defined('AXIOM_UPDATE_NOTIFIER')) define('AXIOM_UPDATE_NOTIFIER', true );


?>