<?php
/**
 * Admin Asset manager
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */
 
/*-----------------------------------------------------------------------------------*/
/*	Add Admin styles
/*-----------------------------------------------------------------------------------*/

function axiom_enqueue_admin_custom_styles() {
    
  // register admin custom styles /////////////////////////////////////////////////
    
  wp_register_style('axiom_base_style' 	     , ADMIN_CSS_URL. 'base.css');
	wp_register_style('axiom_admin_style'      , ADMIN_CSS_URL. 'admin.css');
	wp_register_style('axiom_elements_style'   , ADMIN_CSS_URL. 'elements.css');
  wp_register_style('axiom_rtl_style'        , ADMIN_CSS_URL. 'rtl.css');
  wp_register_style('axiom_option_panel_style',AXI_INC_URL. 'options/assets/css/option-panel.css');
	wp_register_style('axiom_pricetable_style' , AXI_INC_URL. 'price/assets/css/price.css');
  wp_register_style('axiom_pagebuilder_style', AXI_INC_URL. 'modules/builder/assets/css/style.css');
  wp_register_style('axiom_slidermgr_style'  , AXI_INC_URL. 'modules/slider/assets/css/style.css');
    
	wp_register_style('noty'                   , ADMIN_CSS_URL. 'other/noty.css');
  wp_register_style('jquery-ui'              , ADMIN_CSS_URL. 'other/jquery-ui.css');
  wp_register_style('font-awesome'           , '//netdna.bootstrapcdn.com/font-awesome/3.2.1/css/font-awesome.min.css');


    

  // Enqueue admin custom styles /////////////////////////////////////////////////
    
	wp_enqueue_style('axiom_base_style');
	wp_enqueue_style('axiom_admin_style');
	wp_enqueue_style('thickbox');
	wp_enqueue_style('axiom_elements_style');
	wp_enqueue_style('noty');
  wp_enqueue_style('axiom_pagebuilder_style');
    
    
  // It will be called only on option panel page
  if(is_currentpage_id('toplevel_page_axiom'))
      wp_enqueue_style( 'axiom_option_panel_style' );
  
  // just load on pricetable screen
  if(is_currentpage_id('pricetable'))
     wp_enqueue_style('axiom_pricetable_style');
     
  if(is_currentpage_id('slider'))
     wp_enqueue_style('axiom_slidermgr_style');
  
  if(is_currentpage_id('service'))
      wp_enqueue_style('font-awesome');
  
  if(is_rtl())
      wp_enqueue_style('axiom_rtl_style');

  if(is_currentpage_id('news'))
    wp_enqueue_style('jquery-ui');

  /*
  // turn off auto save on edit page
  if(is_currentpage_id('page'))
     wp_dequeue_script('autosave');
  
  // turn off auto save for custom post types edit page 
  
  $post_types = get_post_types( array( '_builtin' => false ), 'objects' ); 
  if (count($post_types) > 0)
      foreach( $post_types as $pt => $args )
          if(is_currentpage_id($pt))
              wp_dequeue_script('autosave');
  */
}

add_action('admin_enqueue_scripts', 'axiom_enqueue_admin_custom_styles');






/*-----------------------------------------------------------------------------------*/
/*	Add Admin Scripts
/*-----------------------------------------------------------------------------------*/

function axiom_enqueue_admin_custom_scripts() {
    global $wp_version;
    $screen = get_current_screen();
    
    
  // register admin custom scripts /////////////////////////////////////////////////
  
	$jquery_ui = array(
		'jquery-ui-core',
		'jquery-ui-accordion',
		'jquery-ui-autocomplete',
		'jquery-ui-button',
		'jquery-ui-datepicker',
		'jquery-ui-datepicker',
		'jquery-ui-dialog',
		'jquery-ui-menu',
		'jquery-ui-mouse',
		'jquery-ui-progressbar',
		'jquery-ui-slider',
		'jquery-ui-position',
		'jquery-ui-resizable',
		'jquery-ui-draggable',
		'jquery-ui-droppable',
		'jquery-ui-selectable',
		'jquery-ui-sortable',
		'jquery-ui-spinner',
		'jquery-ui-tabs',
		'jquery-ui-tooltip',
		'jquery-ui-widget',
		'jquery-effects-core',
		'jquery-effects-blind',
		'jquery-effects-bounce',
		'jquery-effects-clip',
		'jquery-effects-drop',
		'jquery-effects-explode',
		'jquery-effects-fade',
		'jquery-effects-fold',
		'jquery-effects-highlight',
		'jquery-effects-pulsate',
		'jquery-effects-scale',
		'jquery-effects-shake',
		'jquery-effects-size',
		'jquery-effects-slide',
		'jquery-effects-transfer'
	);
    
	// Contains all essential plugins
	wp_register_script('axiom_plugins'			    , ADMIN_JS_URL . 'plugins.js'      , array_merge( array('jquery'), $jquery_ui ) );
    
  // Base64 1.0
  wp_register_script('base64'                 , ADMIN_JS_URL . 'libs/base64.js', null, "1.0" );
  
  // Contains knockout 2.1
  // wp_register_script('knockout'               , ADMIN_JS_URL . 'libs/knockout-2.1.0.js' , array('base64'));
  wp_register_script('knockout'               , ADMIN_JS_URL . 'libs/knockout-3.4.0.js' , array('base64', 'jquery'));
  
  // Contains tipsy 1.0
  wp_register_script('tipsy'                  , ADMIN_JS_URL . 'libs/jquery.tipsy.js');
  
  // Contains iphone-style-checkboxes
  wp_register_script('iphone_checkbox'        , ADMIN_JS_URL . 'libs/iphone-style-checkboxes.js');
  
  // Contains jquery easing functions
  wp_register_script('jquery_easing'          , ADMIN_JS_URL . 'libs/jquery.easing.min.js');
    
	// Contains all general scripts
	wp_register_script('axiom_script'			      , ADMIN_JS_URL . 'script.js'       , array('jquery', 'jquery-ui-slider' ,'jquery-ui-sortable', 'axiom_plugins') );
	
	// Contains all blog post format options
  wp_register_script('axiom_custom'           , ADMIN_JS_URL . 'custom.js'       , array('jquery'), 1.0 ,TRUE );
    
	// Contains scripts for saving option panel data to database
	wp_register_script('axiom_options'			    , AXI_INC_URL. 'options/assets/js/options.js', array('jquery', 'json2', 'axiom_plugins'), "1.22" );
	
	// Contains script for uploading file in option panel
	wp_register_script('axiom_uploader'	        , ADMIN_JS_URL.  'upload.js', array('jquery' , 'media-upload' ,'thickbox') );		
	
    
	//wp_register_script('axiom_slider_manager'	  , AXI_INC_URL. 'slider/assets/js/slider-manager.js', array('jquery' , 'media-upload' ,'thickbox','jquery-ui-sortable', 'axiom_plugins') );														 
    
  // Contains script for pricetable edit page
  wp_register_script('axiom_pricetable'       , AXI_INC_URL. 'price/assets/js/pt.js', array('jquery', 'knockout'), "1.1", TRUE );    
  
  // Contains script for slider manager
  wp_register_script('ckeditor'               , ADMIN_JS_URL . 'libs/ckeditor/ckeditor.js', null, "4.0.1.0");
  
  // Contains script for page builder
  wp_register_script('axiom_pagebuilder'      , AXI_INC_URL. 'modules/builder/assets/js/builder.js', array('jquery','axiom_plugins', 'knockout', 'tipsy','iphone_checkbox', 'ckeditor'), "1.1", TRUE );   
  
  // Contains script for slider manager
  wp_register_script('axiom_slidermgr'        , AXI_INC_URL. 'modules/slider/assets/js/slidermgr.js', array('jquery','axiom_plugins', 'knockout', 'tipsy'), "1.4.0", TRUE );    
  
    
    

    
    
  // Enqueue admin custom scripts /////////////////////////////////////////////////
    
	wp_enqueue_script('jquery');
	wp_enqueue_script('json2' );


  // Print axiom javascript object 
  axiom_admin_js_object();
  

  if( axiom_is_theme_admin_page() ){
        // wp 3.5 and above
        if(function_exists( 'wp_enqueue_media' )){
            wp_enqueue_media();
        }else{
            wp_enqueue_style('thickbox');
            wp_enqueue_script('media-upload');
            wp_enqueue_script('thickbox');
        }
        
        wp_enqueue_script('axiom_plugins');
        wp_enqueue_script('axiom_script');
        wp_enqueue_script('axiom_uploader');
        
        wp_enqueue_style ( 'wp-color-picker' );
        wp_enqueue_script( 'wp-color-picker' );
  }  
  
  // just load on option panel screen
  if(is_currentpage_id('toplevel_page_axiom')){
    wp_enqueue_script('axiom_options');
  }
  
  // just load on slider screen
  if(is_currentpage_id('slider')){
    wp_enqueue_script('axiom_slidermgr');
    wp_dequeue_script('autosave' );
  }
  
  // on pricetable screen
  if(is_currentpage_id('pricetable')){
     wp_enqueue_script('axiom_pricetable');
     wp_dequeue_script('autosave' );
  }

  if(is_currentpage_id('news'))
    wp_enqueue_script('jquery-ui-datepicker');
  
  if(is_currentpage_id('page') || is_currentpage_id('axi_product')
                               || is_currentpage_id('portfolio')
                               || is_currentpage_id('service')
                               || is_currentpage_id('staff')  )
      wp_enqueue_script('axiom_pagebuilder');
  
  if(is_currentpage_id('post'))
      wp_enqueue_script('axiom_custom');
}

add_action('admin_enqueue_scripts', 'axiom_enqueue_admin_custom_scripts');


// the following functions just loads on admin --------------------------------------
/*-----------------------------------------------------------------------------------*/
/*  Whether is the current admin page in list or not
/*-----------------------------------------------------------------------------------*/

function axiom_is_theme_admin_page($admin_pages = array()){
    $admin_pages = empty($admin_pages)?axiom_theme_admin_pages():$admin_pages;
    
    foreach ($admin_pages as $page)
        if( is_currentpage_id($page) )  return true;

    return false;     
}

/*-----------------------------------------------------------------------------------*/
/*  Create essential js global vars
/*-----------------------------------------------------------------------------------*/

function axiom_admin_js_object(){
  
  $axi_upload_dir = wp_upload_dir();
  $axiom_js_obj   = array('themeurl'  => THEME_URL ,
                          'adminurl'  => admin_url(),
                          'ajaxurl'   => admin_url( 'admin-ajax.php' ),
                          'uploadbaseurl' => $axi_upload_dir['baseurl'],
                          'earlyms'   => false );
  
  $axiom_js_obj = apply_filters("axiom_admin_js_object", $axiom_js_obj);

  echo "<script type='text/javascript'> 
          var axiom =".json_encode($axiom_js_obj).";
        </script>";
}
/*-----------------------------------------------------------------------------------*/
?>