<?php
/**
 * Class for managing help pinters
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */

/**
 * 
 */
class AxiomPointers {
	
    /*  */
    public $pointers = array();
    public $seen_ids = array();
    public $not_seen_pointers = array();
    
	function __construct() {  }
    
    
    
    public function add($options = array()){
        // return if no data passed
        if(empty($options) || !is_array($options) ) return false;
        
        $options = array_merge($this->default_point(), $options);
        // add pointer to pointers list
        $this->pointers[] = $options;
        
        return true;
    }
    
    
    
    
    public function init(){
        global $wp_version;
        if ( version_compare( $wp_version, '3.4', '<' ) )
            return false;
        
        if(!count($this->pointers)) return "No Point Available.";
        
        add_action("admin_enqueue_scripts"     , array($this, "add_hooks"));
        add_action('admin_print_footer_scripts', array($this, 'print_pointer_scripts') );
        return true;
    }
    
    
    
    
    
    public function add_hooks(){
        if ( ! current_user_can( 'manage_options' ) ) return;
        
        if(!count($this->pointers)) return false;
        
        $this->seen_ids = explode( ',', (string) get_user_meta( get_current_user_id(), 'dismissed_wp_pointers', true ) );
        
        foreach ($this->pointers as $key => $pointer_data) {
            if(!in_array($pointer_data["id"], $this->seen_ids))
                $this->not_seen_pointers[] = $pointer_data;
        }
        
        if(count($this->not_seen_pointers)) {
            /* Load wp-pointer scripts and styles */
            wp_enqueue_style ( 'wp-pointer' );
            wp_enqueue_script( 'wp-pointer' );
            
            add_action( 'admin_print_footer_scripts', array($this, 'print_pointer_scripts') );
        }
        
        return true;
    }
    
    
    
    
    
    
    public function print_pointer_scripts() {
        if ( ! current_user_can( 'manage_options' ) ) return;
        
        global $hook_suffix;
        $theme_data = wp_get_theme();
        
        foreach ($this->not_seen_pointers as $key => $pointer_data) {
            // check if we are on correct page to display pointer
            if(!empty($pointer_data["hook_suffix"]) && $pointer_data["hook_suffix"] != $hook_suffix) continue;
            // display pointer for spesified theme version and above
            if( version_compare($theme_data["Version"], $pointer_data["version"], '<') ) continue;
?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            if(typeof(jQuery().pointer) != 'undefined') {
                $('<?php echo $pointer_data["target"]; ?>').pointer({
                    content: '<?php printf('<h3>%s</h3><p>%s</p>', $pointer_data["title"],$pointer_data["content"]); ?>',
                    position: {
                        edge: '<?php echo $pointer_data["position"]["edge"]; ?>',
                        align: '<?php echo $pointer_data["position"]["align"]; ?>'
                    },
                    close: function() {
                        $.post( axiom.ajaxurl, {
                            pointer: '<?php echo $pointer_data["id"]; ?>',
                            action: 'dismiss-wp-pointer'
                        });
                    }
                }).pointer('open');
            }
        });
    </script>
<?php
        }
    }
    
    
    
    
    public function default_point(){
        return array(
                    'id'         => 'axi2',        // Unique id for pointer
                    'hook_suffix'=> '',            // Screen hook suffix to show pointer on [empty means display every where on admin] (dashboard : index.php)
                    'target'     => '#menu-settings',// Css selector to hang the pointer to that element
                    'version'    => '1',           // The theme version to display tooltip on
                    'title'      => '',            // Tooltip title
                    'content'    => '',            // Tooltip description
                    'position'   =>  array( 
                                         'edge'  => 'left',  //top, bottom, left, right
                                         'align' => 'middle' //top, bottom, left, right, middle
                                        )
                    );
    }
}

?>