<?php
/**
 * Hooks and functions for option panel
 *
 * 
 * @package    auxin
 * @author     averta (c) 2010-2016
 * @link       http://averta.net

*/


/*-----------------------------------------------------------------------------------*/
/*  Push default option, if it is not set before
/*-----------------------------------------------------------------------------------*/

/**
 * Setup and store theme options if this is the first time on theme activation
 *
 * @return void
 */
function auxin_setup_theme_options() {
    // skip is the options were setup before
    if( get_option( THEME_ID.'_options', '' ) )
        return;

    // generate and save custon styles in css file
    add_action( 'admin_init', array( Auxin_Option::api()->controller, 'save_custom_assets') , 12 );
}

add_action( 'admin_init'        , 'auxin_setup_theme_options' );
add_action( 'after_switch_theme', 'auxin_setup_theme_options' ); // trigger when theme will be actived, WP 3.3


/**
 * Save custom styles on theme activation
 *
 * @return void
 */
function auxin_save_styles_on_theme_activation() {
    add_action( 'admin_init', array( Auxin_Option::api()->controller, 'save_custom_assets' ), 12 );
    flush_rewrite_rules();
}

add_action( 'after_switch_theme', 'auxin_save_styles_on_theme_activation' );


/*-----------------------------------------------------------------------------------*/
/*  Get and inject generate styles in content of custom css file
/*-----------------------------------------------------------------------------------*/

/**
 * Get generated styles by option panel
 *
 * @return string    return generated styles
 */
function auxin_add_header_banner_for_custom_css( $css ){

    ob_start();
    ?>
/*
===============================================================
 #CUSTOM CSS
- Please do not edit this file. This file is generated from admin area.
- Every changes here will be overwritten by theme
===============================================================*/
    <?php

    $css[100] = ob_get_clean();

    return $css;
}

add_filter( 'auxin_custom_css_file_content', 'auxin_add_header_banner_for_custom_css', 9 );


/*-----------------------------------------------------------------------------------*/
/*  Adds user defined JavaScript codes from option panel in JS file
/*-----------------------------------------------------------------------------------*/

function auxin_add_optionpanel_custom_scripts_to_js_file( $js ){

    // Will be deprecated in version 1.4
    unset( $js['option_panel_custom'] );
    unset( $js['option_panel_google_analytics'] );
    unset( $js['option_panel_google_marketing'] );

    return $js;
}

add_filter( 'auxin_custom_js_file_content', 'auxin_add_optionpanel_custom_scripts_to_js_file' );

/*-----------------------------------------------------------------------------------*/
