<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $tabs ) ) :

    $i = 0; ?>

        <section class="widget-container aux-widget-accordion widget-toggle">
            <div class="widget-inner" data-toggle="true">
                <?php foreach ( $tabs as $key => $tab ) : ?>
                    <section <?php echo $i == 0 ? 'class="active"' : '' ?> >
                        <h6 class="<?php echo esc_attr( $key ); ?>_toggle toggle-header">
                            <?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', esc_html( $tab['title'] ), $key ); ?>
                        </h6>
                        <div id="tab-<?php echo esc_attr( $key ); ?>" class="acc-content-wrap panel entry-content">
                            <div class="toggle-content">
                                <?php call_user_func( $tab['callback'], $key, $tab ); ?>
                            </div>
                        </div>
                    </section>
                <?php 
                $i++;
                endforeach; ?>

            </div>
        </section>    

<?php endif; ?>
