
/*========================================================================================
 * Averta.EZ.FadeSlide v1.1
 * Simple jQuery plugin for sliding contents
 * Copyright (c) averta | http://averta.net
 * Dual licensed under the MIT and GPL licenses
 *========================================================================================*/
if(typeof Object.create !== 'function' ){ Object.create = function (obj){ function F(){}; F.prototype = obj; return new F();} };

;(function($){
    
    var Slider = {
        
        init : function(el, options){
            //cache this
            var self        = this;
            self.options    = $.extend({},$.fn.EZfadeSlider.defaultOptions, options || {});
            
            // Access to jQuery and DOM versions of element
            self.$el        = $(el);
            self.el         = el;
            
            self.$slides    = self.$el.find(self.options.slideSelector);
            
            self.total      = self.$slides.length;
            self.current    = self.options.slideToStart;
            
            if(self.total < 2) return;
            self.setup();
        },
        
        setup: function(){
            var self = this;
            self.stop = false;
            
            if(self.options.containerClass)
                self.$el.addClass(self.options.containerClass);
            
            self.updateSliderSize();
            
            self.initControls();
            
            self.$slides.each(function(index) {
                var $this = $(this).hide(0);
                $this.css( {position:'absolute', top:'0'} );
            });
            
            if(self.options.slideshow === "true"){
                self.playTimer();
                
                if(self.options.pauseOnHover === "true"){
                    self.$el.on('mouseenter', function(){
                                self.pauseTimer();
                            })
                            .on('mouseleave', function(){
                                self.playTimer();
                            })
                    };
            }
            
            self.slideContent();
            
            // resize container on window resize
            $(window).bind("debouncedresize", function(){
                self.updateSliderSize();
            });
        },
        
        
        playTimer:function(){
            var self = this;
            if(self.stop) return;
            self.interval = window.setInterval(function(){
                self.goTo(self.current + 1);
            },  self.options.slideshowSpeed)
        },
        
        pauseTimer:function(){
            clearInterval(this.interval);
        },
        
        goTo: function(index){
            
            //hide current slide
            this.$slides.eq(this.current).fadeOut(this.options.animationDuration * .4);
            //recalculate new active index
            this.current = (index < 0)?this.total-1:index % this.total;
            //slideIn new content
            this.slideContent();
        },
        
        goToNextSlide: function(){
            this.goTo(this.current+1);
        },
        
        goToPrevSlide: function(){ 
            this.goTo(this.current-1);
        },
        
        slideContent: function(){
            var self    = this;
            
            var content = self.$slides.eq(self.current).fadeIn(self.options.animationDuration * .6);
        },
        
        updateSliderSize:function(){
            var self = this, max = 0;
            
            self.$slides.each(function(index) {
                var height = $(this).height();
                max = max > height?max:height;
            });
            
            //set container height equal to first child
            self.$el.height(max);
            self.$el.css({ overflow:'hidden' });
        },
        
        initControls: function(){
            var self = this;
            var $next, $prev;
            
            if(!self.options.nextSelector || !self.options.nextSelector) return;
            
            
            $next = (typeof self.options.nextSelector == 'function')?self.options.nextSelector(self.$el):$(self.options.nextSelector);
            if($next != undefined){
                
                $next.on("click", function(e){
                        e.preventDefault();
                        self.stop = true;
                        self.pauseTimer();
                        self.goToNextSlide();
                });
            }
            
            $prev = (typeof self.options.prevSelector == 'function')?self.options.prevSelector(self.$el):$(self.options.prevSelector);
            if($prev != undefined){
                
                $prev.on("click", function(e){
                        e.preventDefault();
                        self.stop = true;
                        self.pauseTimer();
                        self.goToPrevSlide();
                });
            }
        }
    };
    
    
    
     $.fn.EZfadeSlider = function(options){
        return this.each(function(){
            var slider = Object.create(Slider);
            slider.init(this, options);
        });
    };
    
    $.fn.EZfadeSlider.defaultOptions = {
        containerClass: "axi_EZ_slider",
        slideSelector: '> *',
        animation: "fade",      
        slideshow: "true",
        slideshowSpeed:5000,    
        animationDuration: 800,
        slideToStart: 0,
        pauseOnHover: "true",
        nextSelector: null,
        prevSelector: null
    };
    
})(jQuery);

/*========================================================================================
 * debouncedresize: special jQuery event that happens once after a window resize
 * latest version and complete README available on Github:
 * https://github.com/louisremi/jquery-smartresize
 *========================================================================================*/
;(function($){var d=$.event,$special,resizeTimeout;$special=d.special.debouncedresize={setup:function(){$(this).on("resize",$special.handler)},teardown:function(){$(this).off("resize",$special.handler)},handler:function(a,b){var c=this,args=arguments,dispatch=function(){a.type="debouncedresize";d.dispatch.apply(c,args)};if(resizeTimeout){clearTimeout(resizeTimeout)}b?dispatch():resizeTimeout=setTimeout(dispatch,$special.threshold)},threshold:150}})(jQuery);
