/*--------------------------------------------------------------------------------------------------
 *	Option panel Image Uploads
 *-------------------------------------------------------------------------------------------------*/
jQuery(document).ready(function($) {
	axiom_init_optionpanel_uploaders($, $('.av3_container .uploader'));
});

function axiom_init_optionpanel_uploaders($, $container){
	
	$container.each(function(index) {
		
		////////////// get elements ////////////////////////////////////////
		// cache wrapper
		var $this = $(this);
		
		var $input  = $this.find('input[type="text"]').eq(0);
		var $upload = $this.find('input[type="button"]').eq(0);
		var $remove = $this.find('input[type="button"]').eq(1);
		
		var $imgHolder = $this.find('div.imgHolder').addClass('hidden');
		var $close  = $this.find('strong.close').addClass('hidden');
		
		////////////// handlers ////////////////////////////////////////////
		
		// on click image close button
		$close.on('click', function(){
			var $this = $(this);
			var $img  = $this.next('img');
			$img.hide();
			$this.addClass('hidden');
			$imgHolder.addClass('hidden');
			$input.val('');
		});
		
		// on click remove button
		$remove.on('click', function(){
			$input.val('');
			$close.trigger('click');
		});
		
		// on input value change
		$input.on('keyup change blur', function(e){
			if(e.type == 'click' && e.ctrlKey){
				$upload.trigger('click');
			}else{
				updateImage($(e.target));
			}
		});
		
		// on upload btn click
		$upload.on( 'click', function() {
			var $this  = $(this);
			// get input field
			var $input = $this.siblings('input[type="text"]');
			
			// open wp media uploader (since 3.5) ---------------
			
            // If the frame already exists, re-open it.
            if ( frame ) {
                frame.open();
                return;
            }
            
            var frame = wp.media.frames.frame = wp.media({
                title: "Select Image",
                multiple: false,
                frame: 'select',
                library: { type: 'image' },
                button : { text : 'Add Image' }
            });
            
            frame.on( 'select', function() {
                var attachment = frame.state().get('selection').first().toJSON();
                $input.val(attachment.url).trigger('change');
            });
        
            // now let's open media uploader
            frame.open();
			// end - open wp media uploader ---------------------
		});
		
		updateImage($input);
	});
	
	////////////// functions /////////////////////////////////////////////
	
	// updates image preview , if link is changed
	function updateImage($input){
		var $holder = $input.siblings('.imgHolder');
		var $close  = $holder.children('.close');
		var $img    = $close.next('img')
			.on( 'load', function(e) {
				$holder.removeClass('hidden');
				$close.removeClass('hidden' );
				$img.show();
			}).on('error', function(e) {
				$holder.addClass('hidden');
				$close.addClass('hidden' );
				$img.hide();
			});
		
		var img_url = $input.val();
		if (img_url.indexOf("http://") === -1)
			img_url = axiom.uploadbaseurl + '/' + img_url;
		$img.attr('src', img_url);
	}
	
}
