/*//////////////////////////////////////////////////////////////////////////////////////
 * Place any jQuery/helper plugins in here, instead of separate, slower script files!
//////////////////////////////////////////////////////////////////////////////////////*/

/*======================================================================================
 * Javascript prototypes
 *======================================================================================*/
String.prototype.capFirstLetter  = function() { return this.charAt(0).toUpperCase() + this.slice(1); };
String.prototype.capFirstLetters = function() { return this.toLowerCase().replace(/\b[a-z]/g, function(letter) { return letter.toUpperCase(); });};
// add array.indexOf support for IE
if(!Array.prototype.indexOf){Array.prototype.indexOf=function(elt){var len=this.length>>>0;var from=Number(arguments[1])||0;from=(from<0)?Math.ceil(from):Math.floor(from);if(from<0)from+=len;for(;from<len;from++){if(from in this&&this[from]===elt)return from}return-1}};

/*======================================================================================
 * HTML5 Shiv vpre3.6 | @afarkas @jdalton @jon_neal @rem | MIT/GPL2 Licensed
 *======================================================================================*/
;(function(window,document){var options=window.html5||{};var reSkip=/^<|^(?:button|form|map|select|textarea|object|iframe|option|optgroup)$/i;var saveClones=/^<|^(?:a|b|button|code|div|fieldset|form|h1|h2|h3|h4|h5|h6|i|iframe|img|input|label|li|link|ol|option|p|param|q|script|select|span|strong|style|table|tbody|td|textarea|tfoot|th|thead|tr|ul)$/i;var supportsHtml5Styles;var supportsUnknownElements;(function(){var a=document.createElement('a');a.innerHTML='<xyz></xyz>';supportsHtml5Styles=('hidden'in a);if(supportsHtml5Styles&&typeof injectElementWithStyles=='function'){injectElementWithStyles('#modernizr{}',function(node){node.hidden=true;supportsHtml5Styles=(window.getComputedStyle?getComputedStyle(node,null):node.currentStyle).display=='none'})}supportsUnknownElements=a.childNodes.length==1||(function(){try{(document.createElement)('a')}catch(e){return true}var frag=document.createDocumentFragment();return(typeof frag.cloneNode=='undefined'||typeof frag.createDocumentFragment=='undefined'||typeof frag.createElement=='undefined')}())}());function addStyleSheet(ownerDocument,cssText){var p=ownerDocument.createElement('p'),parent=ownerDocument.getElementsByTagName('head')[0]||ownerDocument.documentElement;p.innerHTML='x<style>'+cssText+'</style>';return parent.insertBefore(p.lastChild,parent.firstChild)}function getElements(){var elements=html5.elements;return typeof elements=='string'?elements.split(' '):elements}function shivMethods(ownerDocument){var cache={},docCreateElement=ownerDocument.createElement,docCreateFragment=ownerDocument.createDocumentFragment,frag=docCreateFragment();ownerDocument.createElement=function(nodeName){if(!html5.shivMethods){return docCreateElement(nodeName)}var node;if(cache[nodeName]){node=cache[nodeName].cloneNode()}else if(saveClones.test(nodeName)){node=(cache[nodeName]=docCreateElement(nodeName)).cloneNode()}else{node=docCreateElement(nodeName)}return node.canHaveChildren&&!reSkip.test(nodeName)?frag.appendChild(node):node};ownerDocument.createDocumentFragment=Function('h,f','return function(){'+'var n=f.cloneNode(),c=n.createElement;'+'h.shivMethods&&('+getElements().join().replace(/\w+/g,function(nodeName){docCreateElement(nodeName);frag.createElement(nodeName);return'c("'+nodeName+'")'})+');return n}')(html5,frag)}function shivDocument(ownerDocument){var shived;if(ownerDocument.documentShived){return ownerDocument}if(html5.shivCSS&&!supportsHtml5Styles){shived=!!addStyleSheet(ownerDocument,'article,aside,details,figcaption,figure,footer,header,hgroup,nav,section{display:block}'+'audio{display:none}'+'canvas,video{display:inline-block;*display:inline;*zoom:1}'+'[hidden]{display:none}audio[controls]{display:inline-block;*display:inline;*zoom:1}'+'mark{background:#FF0;color:#000}')}if(!supportsUnknownElements){shived=!shivMethods(ownerDocument)}if(shived){ownerDocument.documentShived=shived}return ownerDocument}var html5={'elements':options.elements||'abbr article aside audio bdi canvas data datalist details figcaption figure footer header hgroup mark meter nav output progress section summary time video','shivCSS':!(options.shivCSS===false),'shivMethods':!(options.shivMethods===false),'type':'default','shivDocument':shivDocument};window.html5=html5;shivDocument(document)}(this,document));

/*======================================================================================
 * jQuery checkbox plugin
 * Copyright (c) 2008 Khavilo Dmitry (http://widowmaker.kiev.ua/checkbox/) | Licensed under the MIT License
 *======================================================================================*/
;(function($){var CB=function(e){if(!e)var e=window.event;e.cancelBubble=true;if(e.stopPropagation)e.stopPropagation()};$.fn.checkbox=function(options){try{document.execCommand('BackgroundImageCache',false,true)}catch(e){}var settings={cls:'jquery-checkbox',empty:'empty.jpg'};settings=$.extend(settings,options||{});var addEvents=function(object){var checked=object.checked;var disabled=object.disabled;var $object=$(object);if(object.stateInterval)clearInterval(object.stateInterval);object.stateInterval=setInterval(function(){if(object.disabled!=disabled)$object.trigger((disabled=!!object.disabled)?'disable':'enable');if(object.checked!=checked)$object.trigger((checked=!!object.checked)?'check':'uncheck')},10);return $object};return this.each(function(){var ch=this;var $ch=addEvents(ch);if(ch.wrapper)ch.wrapper.remove();ch.wrapper=$('<span class="'+settings.cls+'"><span class="mark"><img src="'+settings.empty+'" /></span></span>');ch.wrapperInner=ch.wrapper.children('span:eq(0)');ch.wrapper.hover(function(e){ch.wrapperInner.addClass(settings.cls+'-hover');CB(e)},function(e){ch.wrapperInner.removeClass(settings.cls+'-hover');CB(e)});$ch.css({position:'absolute',zIndex:-1,visibility:'hidden'}).after(ch.wrapper);var label=false;if($ch.attr('id')){label=$('label[for='+$ch.attr('id')+']');if(!label.length)label=false}if(!label){label=$ch.closest?$ch.closest('label'):$ch.parents('label:eq(0)');if(!label.length)label=false}if(label){label.hover(function(e){ch.wrapper.trigger('mouseover',[e])},function(e){ch.wrapper.trigger('mouseout',[e])});label.click(function(e){$ch.trigger('click',[e]);CB(e);return false})}ch.wrapper.click(function(e){$ch.trigger('click',[e]);CB(e);return false});$ch.click(function(e){CB(e)});$ch.bind('disable',function(){ch.wrapperInner.addClass(settings.cls+'-disabled')}).bind('enable',function(){ch.wrapperInner.removeClass(settings.cls+'-disabled')});$ch.bind('check',function(){$ch.attr("checked","checked").val("checked");ch.wrapper.addClass(settings.cls+'-checked')}).bind('uncheck',function(){$ch.removeAttr("checked").val('');ch.wrapper.removeClass(settings.cls+'-checked')});$('img',ch.wrapper).bind('dragstart',function(){return false}).bind('mousedown',function(){return false});if(window.getSelection)ch.wrapper.css('MozUserSelect','none');if(ch.checked)ch.wrapper.addClass(settings.cls+'-checked');if(ch.disabled)ch.wrapperInner.addClass(settings.cls+'-disabled');if(ch.wrapper.hasClass('jquery-checkbox-checked'))$ch.attr("checked","checked")})}})(jQuery);

/*========================================================================================
 * 	An jQuery plugin to serialize checkbox and radio elements
 *========================================================================================*/
;(function($){$.fn.serialize=function(options){return $.param(this.serializeArray(options))};$.fn.serializeArray=function(options){var o=$.extend({checkboxesAsBools:false},options||{});var rselectTextarea=/select|textarea/i;var rinput=/text|hidden|password|search/i;return this.map(function(){return this.elements?$.makeArray(this.elements):this}).filter(function(){return this.name&&!this.disabled&&(this.checked||(o.checkboxesAsBools&&this.type==='checkbox')||rselectTextarea.test(this.nodeName)||rinput.test(this.type))}).map(function(i,elem){var val=$(this).val();return val==null?null:$.isArray(val)?$.map(val,function(val,i){return{name:elem.name,value:val}}):{name:elem.name,value:((o.checkboxesAsBools&&this.type==='checkbox')?(this.checked?'true':'false'):val)}}).get()}})(jQuery);

/*======================================================================================
 * jQuery Noty Plugin v1.1.1 
 * Authors: Nedim Arabacı (http://ned.im), Muhittin Özer (http://muhittinozer.com) http://needim.github.com/noty/
 * Licensed under the MIT licenses: http://www.opensource.org/licenses/mit-license.php
 *======================================================================================*/
;(function($){$.noty=function(options,customContainer){var base=this;var $noty=null;var isCustom=false;base.init=function(options){base.options=$.extend({},$.noty.defaultOptions,options);base.options.type=base.options.cssPrefix+base.options.type;base.options.id=base.options.type+'_'+new Date().getTime();base.options.layout=base.options.cssPrefix+'layout_'+base.options.layout;if(base.options.custom.container)customContainer=base.options.custom.container;isCustom=($.type(customContainer)==='object')?true:false;return base.addQueue()};base.addQueue=function(){var isGrowl=($.inArray(base.options.layout,$.noty.growls)==-1)?false:true;if(!isGrowl)(base.options.force)?$.noty.queue.unshift({options:base.options}):$.noty.queue.push({options:base.options});return base.render(isGrowl)};base.render=function(isGrowl){var container=(isCustom)?customContainer.addClass(base.options.theme+' '+base.options.layout+' noty_custom_container'):$('body');if(isGrowl){if($('ul.noty_cont.'+base.options.layout).length==0)container.prepend($('<ul/>').addClass('noty_cont '+base.options.layout));container=$('ul.noty_cont.'+base.options.layout)}else{if($.noty.available){var fromQueue=$.noty.queue.shift();if($.type(fromQueue)==='object'){$.noty.available=false;base.options=fromQueue.options}else{$.noty.available=true;return base.options.id}}else{return base.options.id}}base.container=container;base.bar=$('<div class="noty_bar"/>').attr('id',base.options.id).addClass(base.options.theme+' '+base.options.layout+' '+base.options.type);$noty=base.bar;$noty.append(base.options.template).find('.noty_text').html(base.options.text);$noty.data('noty_options',base.options);(base.options.closeButton)?$noty.addClass('noty_closable').find('.noty_close').show():$noty.find('.noty_close').remove();$noty.find('.noty_close').bind('click',function(){$noty.trigger('noty.close')});if(base.options.buttons)base.options.closeOnSelfClick=base.options.closeOnSelfOver=false;if(base.options.closeOnSelfClick)$noty.bind('click',function(){$noty.trigger('noty.close')}).css('cursor','pointer');if(base.options.closeOnSelfOver)$noty.bind('mouseover',function(){$noty.trigger('noty.close')}).css('cursor','pointer');if(base.options.buttons){$buttons=$('<div/>').addClass('noty_buttons');$noty.find('.noty_message').append($buttons);$.each(base.options.buttons,function(i,button){bclass=(button.type)?button.type:'gray';$button=$('<button/>').addClass(bclass).html(button.text).appendTo($noty.find('.noty_buttons')).bind('click',function(){if($.isFunction(button.click)){button.click.call($button,$noty)}})})}return base.show(isGrowl)};base.show=function(isGrowl){if(base.options.modal)$('<div/>').addClass('noty_modal').addClass(base.options.theme).prependTo($('body')).fadeIn('fast');$noty.close=function(){return this.trigger('noty.close')};(isGrowl)?base.container.prepend($('<li/>').append($noty)):base.container.prepend($noty);if(base.options.layout=='noty_layout_topCenter'||base.options.layout=='noty_layout_center'){$.noty.reCenter($noty)}$noty.bind('noty.setText',function(event,text){$noty.find('.noty_text').html(text);$.noty.reCenter($noty)});$noty.bind('noty.getId',function(event){return $noty.data('noty_options').id});$noty.one('noty.close',function(event){var options=$noty.data('noty_options');if(options.modal)$('.noty_modal').fadeOut('fast',function(){$(this).remove()});$noty.clearQueue().stop().animate($noty.data('noty_options').animateClose,$noty.data('noty_options').speed,$noty.data('noty_options').easing,$noty.data('noty_options').onClose).promise().done(function(){if($.inArray($noty.data('noty_options').layout,$.noty.growls)>-1){$noty.parent().remove()}else{$noty.remove();$.noty.available=true;base.render(false)}})});$noty.animate(base.options.animateOpen,base.options.speed,base.options.easing,base.options.onShow);if(base.options.timeout)$noty.delay(base.options.timeout).promise().done(function(){$noty.trigger('noty.close')});return base.options.id};return base.init(options)};$.noty.get=function(id){return $('#'+id)};$.noty.close=function(id){$.noty.get(id).trigger('noty.close')};$.noty.setText=function(id,text){$.noty.get(id).trigger('noty.setText',text)};$.noty.closeAll=function(){$.noty.clearQueue();$('.noty_bar').trigger('noty.close')};$.noty.reCenter=function(noty){noty.css({'left':($(window).width()-noty.outerWidth())/2+'px'})};$.noty.clearQueue=function(){$.noty.queue=[]};$.noty.queue=[];$.noty.growls=['noty_layout_topLeft','noty_layout_topRight','noty_layout_bottomLeft','noty_layout_bottomRight'];$.noty.available=true;$.noty.defaultOptions={layout:'top',theme:'noty_theme_default',animateOpen:{height:'toggle'},animateClose:{height:'toggle'},easing:'swing',text:'',type:'alert',speed:500,timeout:5000,closeButton:false,closeOnSelfClick:true,closeOnSelfOver:false,force:false,onShow:false,onClose:false,buttons:false,modal:false,template:'<div class="noty_message"><span class="noty_text"></span><div class="noty_close"></div></div>',cssPrefix:'noty_',custom:{container:null}};$.fn.noty=function(options){return this.each(function(){(new $.noty(options,$(this)))})}})(jQuery);function noty(options){return jQuery.noty(options)};

/*=======================================================================================
 * AvertaColorpicker v1.0.1 | Copyright (c) averta | http://averta.net
 * An jQuery polyfill for color input, based on "Color picker" plugin
 *=======================================================================================*/
;(function($){var Colorpicker={init:function(el,options){var self=this;self.options=$.extend({},$.fn.avertaColorpicker.defaultOptions,options||{});self.$el=$(el);self.el=el;self.setup()},setup:function(){var self=this;var $input=$('<input/>',{'id':self.$el.attr('id'),'name':self.$el.attr('name'),'class':self.$el.attr('class'),'type':'text','width':'60px','height':'25px'}).val(self.$el.val()).on('change',self.onColorpicker_update).on('keyup',self.onColorpicker_update);self.$el.replaceWith($input);$input.wrap('<div class="colorpicker_section" />');var $parent=$input.parent();var $selector=$('<span/>',{'class':'colorSelector'});$selector.prependTo($parent).css({'background-color':'#'+$input.val()}).ColorPicker({onBeforeShow:function(){$(this).ColorPickerSetColor($input.val())},onSubmit:function(hsb,hex,rgb,el){var $el=$(el);var $input=$el.siblings('input');$input.val(hex).change()}})},onColorpicker_update:function(){var $this=$(this);var $picker=$this.siblings('span');if($picker.length){var hex=$this.val();if(hex.toString().indexOf('#')!==-1){hex=hex.toString().replace("#","");$this.val(hex)}if(hex.toString().length<6)return;$picker.css('background-color','#'+$this.val())}}};$.fn.avertaColorpicker=function(options){return this.each(function(){var cp=Object.create(Colorpicker);cp.init(this,options)})};$.fn.avertaColorpicker.defaultOptions={addSelector:'true'}})(jQuery);

/*=======================================================================================
 * AvertaRangeControl v1.1 | Copyright (c) averta | http://averta.net
 * An jQuery polyfill for range input, based on jQuery UI
 *=======================================================================================*/
;(function($){var Range={init:function(el,options){var self=this;self.options=$.extend({},$.fn.avertaRangeControl.defaultOptions,options||{});self.$el=$(el);self.el=el;self.setup()},setup:function(){var self=this;var o_value=(self.el.value)?(self.el.value):self.options.value;var o_min=(self.$el.attr('min'))?self.$el.attr('min'):self.options.min;var o_max=(self.$el.attr('max'))?self.$el.attr('max'):self.options.max;var o_step=(self.$el.attr('step'))?self.$el.attr('step'):self.options.step;var _name=self.$el.attr('name');var _id=self.$el.attr('id');var $container=$('<div/>').addClass('clearfix');var $textbox=$('<input/>',{'id':_id,'name':_name,'type':'text','class':self.$el.attr('class'),'min':self.$el.attr('min'),'max':self.$el.attr('max'),'step':o_step}).css({'width':self.options.textboxWidth+'px','height':'26px','text-align':'center','float':'left'}).val(o_value).on('keyup',self.onTextbox_change).appendTo($container);var newElement=$('<div/>').val(o_value);self.$el.replaceWith(newElement);self.$el=newElement;if(self.options.displayTextbox=='true')self.$el.css({'margin-top':'8px','margin-left':(self.options.textboxWidth+10)+'px'});else $textbox.css({'display':'none'});$container.prependTo(self.$el.parent()).append(self.$el);self.$el.slider({range:"min",value:~~o_value,min:~~o_min,max:~~o_max,step:~~o_step,slide:function(event,ui){input=event.target.parentNode;do{input=input.previousSibling}while(input&&input.nodeType!=1);if(input)input.value=ui.value}});self.onSlider_update(self.$el,self.$el.val())},onSlider_update:function($slider,value){$slider.siblings('input').val(value)},onTextbox_change:function(event){var $this=$(event.currentTarget);var $slider=$this.siblings('.ui-slider');var min=parseInt($this.attr('min'));var max=parseInt($this.attr('max'));var val=parseInt($this.val());if(val>max)val=max;if(val<min||isNaN(val))val=min;$this.val(val);$slider.slider("option","value",val)}};$.fn.avertaRangeControl=function(options){return this.each(function(){var range=Object.create(Range);range.init(this,options)})};$.fn.avertaRangeControl.defaultOptions={value:50,min:0,max:100,step:1,displayTextbox:'true',textboxWidth:50}})(jQuery);

/*=======================================================================================
 * http://mths.be/placeholder v2.0.7 by @mathias
 *=======================================================================================*/
;(function(f,h,$){var a='placeholder' in h.createElement('input'),d='placeholder' in h.createElement('textarea'),i=$.fn,c=$.valHooks,k,j;if(a&&d){j=i.placeholder=function(){return this};j.input=j.textarea=true}else{j=i.placeholder=function(){var l=this;l.filter((a?'textarea':':input')+'[placeholder]').not('.placeholder').bind({'focus.placeholder':b,'blur.placeholder':e}).data('placeholder-enabled',true).trigger('blur.placeholder');return l};j.input=a;j.textarea=d;k={get:function(m){var l=$(m);return l.data('placeholder-enabled')&&l.hasClass('placeholder')?'':m.value},set:function(m,n){var l=$(m);if(!l.data('placeholder-enabled')){return m.value=n}if(n==''){m.value=n;if(m!=h.activeElement){e.call(m)}}else{if(l.hasClass('placeholder')){b.call(m,true,n)||(m.value=n)}else{m.value=n}}return l}};a||(c.input=k);d||(c.textarea=k);$(function(){$(h).delegate('form','submit.placeholder',function(){var l=$('.placeholder',this).each(b);setTimeout(function(){l.each(e)},10)})});$(f).bind('beforeunload.placeholder',function(){$('.placeholder').each(function(){this.value=''})})}function g(m){var l={},n=/^jQuery\d+$/;$.each(m.attributes,function(p,o){if(o.specified&&!n.test(o.name)){l[o.name]=o.value}});return l}function b(m,n){var l=this,o=$(l);if(l.value==o.attr('placeholder')&&o.hasClass('placeholder')){if(o.data('placeholder-password')){o=o.hide().next().show().attr('id',o.removeAttr('id').data('placeholder-id'));if(m===true){return o[0].value=n}o.focus()}else{l.value='';o.removeClass('placeholder');l==h.activeElement&&l.select()}}}function e(){var q,l=this,p=$(l),m=p,o=this.id;if(l.value==''){if(l.type=='password'){if(!p.data('placeholder-textinput')){try{q=p.clone().attr({type:'text'})}catch(n){q=$('<input>').attr($.extend(g(this),{type:'text'}))}q.removeAttr('name').data({'placeholder-password':true,'placeholder-id':o}).bind('focus.placeholder',b);p.data({'placeholder-textinput':q,'placeholder-id':o}).before(q)}p=p.removeAttr('id').hide().prev().attr('id',o).show()}p.addClass('placeholder');p[0].value=p.attr('placeholder')}else{p.removeClass('placeholder')}}}(this,document,jQuery));

/*=======================================================================================
 * AvertaPrettySelector v1.0 | Copyright (c) averta | http://averta.net
 * An jQuery for making elements selectable
 *=======================================================================================*/
;(function($){var SelectionList={init:function(el,options){var self=this;self.options=$.extend({},$.fn.avertaPrettySelector.defaultOptions,options||{});self.$el=$(el);self.el=el;self.setup()},setup:function(){var self=this;var $itemsWrapper,$itemWrapper;self.$inputs=self.$el.find('input[type="checkbox"]');$itemsWrapper=$('<'+self.options.itemsWrapper+' />',{'class':self.options.itemsWrapperClass});self.$inputs.each(function(index){var $this=$(this);var $label,$image,src;if($this.parent().get(0).tagName==='LABEL'){$label=$this.parent()}else if($this.next().get(0).tagName==='LABEL'){$label=$this.next()}else if($this.prev().get(0).tagName==='LABEL'){$label=$this.prev()}else{console.log('FROM prettySelector PLUGIN : No Label element found.')}var $input=$('<input/>',{'id':$this.attr('id'),'class':$this.attr('class'),'type':'checkbox','name':$this.attr('name')}).css('display','none').addClass('pretty-selector');$itemWrapper=$('<'+self.options.itemWrapper+' />',{'class':self.options.itemWrapperClass}).append($input).css('cursor','pointer').on('click',{'self':self},self.onItem_clicked);if($this.data('src')&&$this.data('src')!==''){$image=$('<img />',{'alt':$label.text()||'','title':$label.text()||'','src':$this.data('src')}).appendTo($itemWrapper)}if($this.is(':checked')){$input.attr('checked','checked').val("checked");$itemWrapper.addClass("selected")}$itemWrapper.appendTo($itemsWrapper)});self.$el.empty().append($itemsWrapper)},onItem_clicked:function(event){var self=event.data.self;var $el=$(this);var $input=$el.find('input');if(self.options.multiSelection=='false'){var $els=$el.siblings();$els.removeClass('selected');$el.addClass('selected');$els.find('input[type="checkbox"]').removeAttr('checked').val('');$input.attr('checked','checked').val('checked')}else{if($input.is(':checked')){$input.removeAttr('checked').val('');$el.removeClass('selected')}else{$input.attr('checked','checked').val('checked');$el.addClass('selected')}}}};$.fn.avertaPrettySelector=function(options){return this.each(function(){var sl=Object.create(SelectionList);sl.init(this,options)})};$.fn.avertaPrettySelector.defaultOptions={multiSelection:'true',itemsWrapper:'ul',itemsWrapperClass:'selection-list',itemWrapper:'li',itemWrapperClass:''}})(jQuery);


/*=======================================================================================
 * Averta.VisualSelector v1.1 | Copyright (c) averta | http://averta.net | 2013.06
 * An jQuery for making elements selectable
 *=======================================================================================*/
;(function($){var j={init:function(a,b){var c=this;c.options=$.extend({},$.fn.avertaVisualSelector.defaultOptions,b||{});c.$el=$(a);c.el=a;c.setup()},setup:function(){var d=this;var f,$itemWrapper;d.$options=d.$el.find('option');var g=$('<'+d.options.containerElement+' />').attr({'class':d.options.containerClass});d.$el.wrap(g);d.$container=d.$el.parent();var h=$('<a />').attr({"class":"button "+d.options.toggleBtnClass,"href":"#"}).text(d.options.toggleBtnLabel);d.$container.append(h);h=d.$container.children(".button");var f=$('<'+d.options.itemsWrapper+' />').addClass(d.options.itemsWrapperClass);f.appendTo(d.$container);d.$itemsWrapper=d.$container.children(d.options.itemsWrapper);h.on("click",function(e){e.preventDefault();d.$itemsWrapper.slideToggle(600,"easeOutQuart")});var i=d.$el.attr("data");d.$options.each(function(a){var b=$(this);var c=b.attr("value");if(!c)return true;$itemWrapper=$('<'+d.options.itemWrapper+' />',{'class':d.options.itemWrapperClass}).append($('<i />',{'class':c+" icon-2x",'data-name':c,'title':c.substring(5)})).on('click',{'self':d},d.onView_clicked);if(i==c)$itemWrapper.addClass(d.options.selectedClass);$itemWrapper.appendTo(d.$itemsWrapper)});d.$el.on("change",{'self':d},d.onDropdown_changed)},onView_clicked:function(a){var b=a.data.self;var c=$(this);var d=c.children("i").attr("data-name");b.$el.val(d);if(b.options.multiSelection=='false'){c.siblings().removeClass(b.options.selectedClass).end().addClass(b.options.selectedClass)}else{c.addClass(b.options.selectedClass)}},onDropdown_changed:function(a){var b=a.data.self;var c=$(this);b.$itemsWrapper.find("li").removeClass(b.options.selectedClass).find("i."+c.val()).parent().addClass(b.options.selectedClass)}};$.fn.avertaVisualSelector=function(b){return this.each(function(){var a=Object.create(j);a.init(this,b)})};$.fn.avertaVisualSelector.defaultOptions={multiSelection:'true',selectedClass:'selected',containerElement:'div',containerClass:'axi-vs-container',itemsWrapper:'ul',itemsWrapperClass:'selection-list',itemWrapper:'li',itemWrapperClass:'',toggleBtnClass:'vs-btn-toggle',toggleBtnLabel:'Toggle Visual Selector'}})(jQuery);

/*=======================================================================================
 * AvertaLiveTabs v1.0 | Copyright (c) averta | http://averta.net
 * An jQuery for enabling tabs
 *=======================================================================================*/

if(typeof Object.create !== 'function' ){ Object.create = function (obj){ function F(){} F.prototype = obj;return new F();};}

;(function($){
    
    var Container = {
        
        init : function(el, options){
            //cache this
            var self        = this;
            self.options    = $.extend({} ,$.fn.avertaLiveTabs.defaultOptions, options || {} );
            
            // Access to jQuery and DOM versions of element
            self.$el        = $(el);
            self.el         = el;
            
            self.$tabs      = self.$el.find(self.options.tabs);
            self.$contents  = self.$el.find(self.options.contents);
            
            self.setup();
        },
        
        setup: function(){
            var self = this,
                $active_tab,
                $active_content;
            // click event when new tab selected
            self.$tabs.on('click', {self:self}, self.onTabClicked);

            // if hash is enabled in options get current hash and select related tab
            if(self.options.enableHash && window.location.hash !== '') {
                var id      = window.location.hash.substring(1);
                $active_tab     = self.getTabById(id);
            } else {
                // find the tab with tabsActiveClass
                $active_tab     = self.$tabs.filter('.'+self.options.tabsActiveClass);
            }
            // validate to select the active tab for start
            $active_tab     = ($active_tab.length)?$active_tab:self.$tabs.first();
            $active_tab.trigger('click');
            
        },
        
        onTabClicked:function(event){
            event.preventDefault();
            var self   = event.data.self,
                $this  = $(this),
                $tab_content,
                active_id;
            
            self.$tabs.removeClass(self.options.tabsActiveClass);
            $this.addClass(self.options.tabsActiveClass);
            
            self.$contents.hide();
            if(self.options.connectType == 'id'){
                active_id    = self.getIdByTab($this);
                $tab_content = self.getContentById(active_id);
            } else{
                $tab_content = self.$contents.eq($this.index());
            }
            $tab_content.fadeIn(self.options.duration);

            // update hash in page address if updateHash is enabled
            if(self.options.updateHash){
                active_id  = self.getIdByTab($this);
                active_id  = active_id?active_id+self.options.hashSuffix:'';

                if(window.history && window.history.pushState )
                    window.history.pushState(null, null, window.location.href.split('#')[0]+'#'+active_id);
                else
                    window.location.hash = active_id;
            }
        },

        getTabById:function(id){
            // remove hashSuffix (if exist) from id hash to get real element id
            id = id.split(this.options.hashSuffix)[0];
            // search for hash in tabs markup - generaly should be direct children of tab
            // check for href="#id" format
            var $active_tab = this.$tabs.find('[href="#'+ id +'"]').eq(0);
            // if no match found, check for href="id" format too
            if(!$active_tab.length)
                $active_tab = this.$tabs.find('[href="'+ id +'"]').eq(0);
            // get the tab if hash found in it
            return $active_tab.length?$active_tab.parent():$active_tab;
        },

        getContentById:function(id){
            return this.$contents.filter('#'+id);
        },

        getIdByTab:function($tab){
            var $anchor = $tab.find('[href]').eq(0);
            return $anchor.length?$anchor.attr('href'):false;
        }
    };
    
    
    
     $.fn.avertaLiveTabs = function(options){
        return this.each(function(){
            var container = Object.create(Container);
            container.init(this, options);
        });
    };
    
    $.fn.avertaLiveTabs.defaultOptions = {
        tabs:            'ul.tabs > li',            // Tabs selector
        tabsActiveClass: 'active',                  // A Class that indicates active tab
        contents:        'ul.tabs-content > li',    // Tabs content selector    
        contentsActiveClass: 'active',              // A Class that indicates active tab-content    
        transition:      'fade',                    // Animation type white swiching tabs
        duration :       '500',                     // Animation duration in mili seconds
        connectType:     'index',                   // connect tabs and contents by 'index' or 'id'
        enableHash:      false ,                    // check to select initial tab based on hash address
        updateHash:      false ,                    // update hash in browser while switching between tabs
        hashSuffix:      '-tab'                     // suffix to add at the end of hash url to prevent page scroll
    };
    
})(jQuery);
