<?php

/*-----------------------------------------------------------------------------------*/
/*  Video
/*-----------------------------------------------------------------------------------*/
    
add_shortcode( 'vimeo'  , 'axiom_shortcode_video_element' );
add_shortcode( 'youtube', 'axiom_shortcode_video_element' );
add_shortcode( 'utube'  , 'axiom_shortcode_video_element' );
add_shortcode( 'axi-video-embed', 'axiom_shortcode_video_element' );
add_shortcode( 'video-element'  , 'axiom_shortcode_video_element' );
add_shortcode( 'video_element'  , 'axiom_shortcode_video_element' );


/**
 * The Video Element shortcode.
 *
 * This implements the functionality of the Video Shortcode for displaying
 * Videos in styles section
 *
 * @since 3.6.0
 *
 * @param  array $atts Attributes of the shortcode.
 * @param  string HTML content
 * @return string HTML content to display video.
 */
function axiom_shortcode_video_element( $attr, $content = null ) {
   global $axiom_options;
   // iframe embed codes can be passed by $content
   
   // You can use shortcode_atts_axiom_video filter hooks to filter atts
   $atts =  shortcode_atts( 
                            array( 
                                'size'      => '',    // section size
                                'title'     => '',    // section title
                                'autoplay'  => '',    // play video automaticaly
                                'loop'      => '',    // loop video
                                'width'     => '',    // default video size
                                'height'    => '',    // default video height
                                'fit'       => 'yes', // makes video responsive
                                'full'      => '',    // makes video responsive
                                'url'       => '',
                                'src'       => '',    // quick set for mp4 file
                                'mp4'       => '',
                                'ogg'       => '',
                                'webm'      => '',
                                'flv'       => '',
                                'poster'    => '',
                                'skin'      => 'dark',
                                'uid'       => ''
                            )
                            , $attr, 'axiom_video_element' ); 
    
    extract($atts);
    
    // create an unique id for video element if is not set
    if(empty($uid)) $uid = uniqid("axi");
    
    // full is equal to fit. usage : tinymce shortcode
    if(!empty($full)) $fit = $full;
    
    
    $skin = $skin == 'dark'?'':' media-skin-light';
    
    ob_start();
?>
      
        <section class="widget-video  <?php echo axiom_get_grid_name($size).$skin; ?>">
            
            <?php if(!empty($title))  echo get_widget_title($title, ""); 
            
            
            // check if vimeo or youtube is set
            if(!empty($url)) {
                
                // is youtube url
                if(strpos($url, 'watch?v=') !== FALSE){
                    $linkparts = explode('watch?v=', $url);
                    $linkparts = explode('&', $linkparts[1]);
                    $url       = 'http://www.youtube.com/embed/'.$linkparts[0];
                }elseif(strpos($url, 'youtu.be') !== FALSE){
                    $linkparts = explode('youtu.be/', $url);
                    $linkparts = explode('&', $linkparts[1]);
                    $url       = 'http://www.youtube.com/embed/'.$linkparts[0];
                // is vimeo url
                }elseif(strpos($url, 'vimeo.com') !== FALSE){
                    if(strpos($url, 'vimeo.com/video') === FALSE){
                        $linkparts = explode('vimeo.com/', $url);
                        $url       = 'http://player.vimeo.com/video/'.$linkparts[1];
                    }
                }
                // default size for videos with 16:9 aspect ratio
                $width  = empty($width )?500:$width;
                $height = empty($height)?281:$height; 
                
                $control_color = isset($axiom_options['feature_color'])?$axiom_options['feature_color']:"#00adef";
                $control_color = substr($control_color, 1);
            ?>
            <iframe src="<?php echo $url; ?>?title=0&amp;byline=0&amp;portrait=0&amp;badge=0&amp;color=<?php echo $control_color; ?>" width="<?php echo $width; ?>" height="<?php echo $height; ?>" data-fit="<?php echo $fit; ?>" frameborder="0" ></iframe>
            <?php
            } 
            // if it was not youtube vimeo link
            // if embed code (iframe) is set return embeded video
            elseif(!empty($content)){
                printf('<div class="video-embed-container fit-embed-vid-%s">%s</div>', $fit, $content);
            }
            // if any video file is set
            elseif(!empty($src) || !empty($mp4) || !empty($ogg) || !empty($webm) || !empty($flv)) {
                echo axiom_shortcode_video_responsive($atts);
            }
            ?>
            
        </section><!-- end widget-video -->
        
<?php
    return ob_get_clean();
}





/**
 * The Video shortcode.
 *
 * This implements the functionality of the Video Shortcode for displaying
 * self hosted video files responsively
 *
 * @since 3.6.0
 *
 * @param array $attr Attributes of the shortcode.
 * @return string HTML content to display video.
 */
function axiom_shortcode_video_responsive( $attr ) {
    global $content_width;
    $post_id = get_post() ? get_the_ID() : 0;

    static $instances = 0;
    $instances++;

    $video = null;

    $default_types = wp_get_video_extensions();
    $defaults_atts = array(
        'src'      => '',
        'poster'   => '',
        'loop'     => '',
        'autoplay' => '',
        'preload'  => 'metadata',
        'height'   => 360,
        'width'    => empty( $content_width ) ? 640 : $content_width,
    );

    foreach ( $default_types as $type )
        $defaults_atts[$type] = '';

    $atts = shortcode_atts( $defaults_atts, $attr, 'video' );
    extract( $atts );

    $w = $width;
    $h = $height;
    if ( is_admin() && $width > 600 )
        $w = 600;
    elseif ( ! is_admin() && $w > $defaults_atts['width'] )
        $w = $defaults_atts['width'];

    if ( $w < $width )
        $height = round( ( $h * $w ) / $width );

    $width = $w;

    $primary = false;
    if ( ! empty( $src ) ) {
        $type = wp_check_filetype( $src, wp_get_mime_types() );
        if ( ! in_array( $type['ext'], $default_types ) )
            return sprintf( '<a class="wp-embedded-video" href="%s">%s</a>', esc_url( $src ), esc_html( $src ) );
        $primary = true;
        array_unshift( $default_types, 'src' );
    } else {
        foreach ( $default_types as $ext ) {
            if ( ! empty( $$ext ) ) {
                $type = wp_check_filetype( $$ext, wp_get_mime_types() );
                if ( $type['ext'] === $ext )
                    $primary = true;
            }
        }
    }

    if ( ! $primary ) {
        $videos = get_attached_media( 'video', $post_id );
        if ( empty( $videos ) )
            return;

        $video = reset( $videos );
        $src = wp_get_attachment_url( $video->ID );
        if ( empty( $src ) )
            return;

        array_unshift( $default_types, 'src' );
    }

    $library = apply_filters( 'wp_video_shortcode_library', 'mediaelement' );
    if ( 'mediaelement' === $library && did_action( 'init' ) ) {
        wp_enqueue_style( 'wp-mediaelement' );
        wp_enqueue_script( 'wp-mediaelement' );
    }

    $atts = array(
        'class'    => apply_filters( 'wp_video_shortcode_class', 'wp-video-shortcode' ),
        'id'       => sprintf( 'video-%d-%d', $post_id, $instances ),
        'width'    => absint( $width ),
        'height'   => absint( $height ),
        'poster'   => esc_url( $poster ),
        'loop'     => $loop,
        'autoplay' => $autoplay,
        'preload'  => $preload,
        'style'    => 'width:100%; height:100%;' // enbale responsiveness - averta
    );

    // These ones should just be omitted altogether if they are blank
    foreach ( array( 'poster', 'loop', 'autoplay', 'preload' ) as $a ) {
        if ( empty( $atts[$a] ) )
            unset( $atts[$a] );
    }

    $attr_strings = array();
    foreach ( $atts as $k => $v ) {
        $attr_strings[] = $k . '="' . esc_attr( $v ) . '"';
    }

    $html = '';
    if ( 'mediaelement' === $library && 1 === $instances )
        $html .= "<!--[if lt IE 9]><script>document.createElement('video');</script><![endif]-->\n";
    $html .= sprintf( '<video %s controls="controls">', join( ' ', $attr_strings ) );

    $fileurl = '';
    $source = '<source type="%s" src="%s" />';
    foreach ( $default_types as $fallback ) {
        if ( ! empty( $$fallback ) ) {
            if ( empty( $fileurl ) )
                $fileurl = $$fallback;
            $type = wp_check_filetype( $$fallback, wp_get_mime_types() );
            // m4v sometimes shows up as video/mpeg which collides with mp4
            if ( 'm4v' === $type['ext'] )
                $type['type'] = 'video/m4v';
            $html .= sprintf( $source, $type['type'], esc_url( $$fallback ) );
        }
    }
    if ( 'mediaelement' === $library )
        $html .= wp_mediaelement_fallback( $fileurl );
    $html .= '</video>';

    $html = sprintf( '<div style="width: %dpx; max-width: 100%%;">%s</div>', $width, $html );
    return apply_filters( 'wp_video_shortcode', $html, $atts, $video, $post_id, $library );
}

remove_shortcode( 'video' );
add_shortcode( 'video', 'axiom_shortcode_video_responsive' );


?>