<?php 

/*-----------------------------------------------------------------------------------*/
/*  MasterSlider shortcode for Page Builder
/*-----------------------------------------------------------------------------------*/

add_shortcode( 'masterslider_axi', 'axiom_masterslider_axi_shortcode' );

function axiom_masterslider_axi_shortcode( $atts, $content = null ) {
	$mixed = shortcode_atts( 
		array( 
		      'id' 	  => '', 
		      'title' => '',
		      'class' => '',
		      'size'  => '100'
		),
		$atts, 
		'masterslider_axi'
	);

	extract( $mixed );

	if( ! is_numeric( $id ) ) 
		return __( 'Invalid slider id', 'default' );

	if ( ! defined( 'MSWP_AVERTA_VERSION' ) ) 
		return __( 'Please install and activate Masterslider WP', 'default' );
	

	$wrapper_open_tag  = sprintf( '<section class="widget-slider %s %s" >', esc_attr( $class ), axiom_get_grid_name( $size ) );
	$the_title_tag     = empty( $title ) ? '' : get_widget_title( $title, '');
	$wrapper_close_tag = '</section>';
	$slider_markup     = get_masterslider( $id );
	$output 		   = $wrapper_open_tag . $the_title_tag . $slider_markup . $wrapper_close_tag;

	return apply_filters( 'masterslider_axi_shortcode', $output, $slider_markup, $wrapper_open_tag, $the_title_tag, $wrapper_close_tag );
}

?>