<?php
/**
 * Functions for enaplaing styling options
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */
 
 
//// Update site custom styles  //////////////////////////////////////////////////////////////////////


/*-----------------------------------------------------------------------------------*/
/*  Gets current style options and stores them in css file
 *  This function will be called by option panel's save handler
/*-----------------------------------------------------------------------------------*/

function axi_save_custom_styles(){
    global $axiom_options;
    $styles = $axiom_options;
    
    $css_file  = get_template_directory() . '/css/other/custom.css';
    
    ob_start();
    
    require(AXI_INC.'options/styling/terms.php');
    require(AXI_CON.'options/styling/index.php');
    
    $css = ob_get_clean();
    
    // write to custom.css file
    WP_Filesystem();
    global $wp_filesystem;
    
    if ( ! $wp_filesystem->put_contents( $css_file, $css, 0644) ) {
        // if the directory is not writable, try inline css fallback
        update_option( 'axiom_'.THEME_ID.'_custom_CSS_options' , $css); // save css rules as option to print as inline css
    }else {
        update_option( 'axiom_'.THEME_ID.'_custom_CSS_options' , ""); // disable inline css output
    }
    
    // creates css query for loading google fonts, and registers css to enqueue by wp
    axi_register_custom_gfonts();
}

/*-----------------------------------------------------------------------------------*/
/*  gets google fonts in json format and converts them to an array
 *  this function does not call by theme , it's a manual parser
/*-----------------------------------------------------------------------------------*/

function axi_filter_json_google_fonts(){
    
    // get all fonts from json files
    $g_font_list = file_get_contents( AXI_INC_URL .'options/styling/cache/allfonts.json');
    $g_font_list = json_decode($g_font_list);
    $g_font_list = $g_font_list->items;
    
    // an array to store font lists from json data
    $list = array();
    // how many font you want to return
    $get_num = 1000;
    
    foreach ($g_font_list as $item) {
        if($get_num < 0) break;
        $font = array();
        $font['css']    = str_replace(" ", "+", $item->family );
        $font['styles'] = $item->variants;
        
        $list[$item->family] = $font;
        --$get_num;
    }
    
    return serialize($list);
}

//var_dump(axi_filter_json_google_fonts());

/*-----------------------------------------------------------------------------------*/
/*  check the font name if it is google font
/*-----------------------------------------------------------------------------------*/

function axi_is_googlefont($fontname){
    $pos = strpos($fontname, "EaA_");
    return ($pos === false) && preg_match('/[A-Z]/', $fontname);
}

/*-----------------------------------------------------------------------------------*/
/*  check the font name if it is earlyaccess google font
/*-----------------------------------------------------------------------------------*/

function axi_is_earlyaccess_googlefont($fontname){
    $pos = strpos($fontname, "EaA_");
    return ($pos !== false);
}

/*-----------------------------------------------------------------------------------*/
/*  get all fonts list
/*-----------------------------------------------------------------------------------*/

function axiom_get_fonts_list(){
    $fonts_list = array();

    $fonts_list[] = array(  "id"        => "system_group",
                            "title"     => __("System fonts", "default"),
                            "faces"     => array(   'arial'     =>'Arial',
                                                    'verdana'   =>'Verdana',
                                                    'trebuchet' =>'Trebuchet',
                                                    'georgia'   =>'Georgia',
                                                    'times'     =>'Times New Roman',
                                                    'tahoma'    =>'Tahoma',
                                                    'palatino'  =>'Palatino',
                                                    'helvetica' =>'Helvetica' )  );


    $fonts_list[] = array(  "id"        => "google_group",
                            "title"     => __("Google fonts", "default"),
                            "faces"     => axi_get_google_font_names() );


    $fonts_list[] = array(  "id"        => "early_google_group",
                            "title"     => __("Google fonts", "default"),
                            "faces"     => array( 'EaA_Alef Hebrew'         => 'Alef Hebrew (Hebrew)',
                                                  'EaA_Amiri'               => 'Amiri (Arabic)',
                                                  'EaA_Dhyana'              => 'Dhyana (Lao)',
                                                  'EaA_Droid Arabic Kufi'   => 'Droid Arabic Kufi (Arabic)',
                                                  'EaA_Droid Arabic Naskh'  => 'Droid Arabic Naskh(Arabic)',
                                                  'EaA_Droid Sans Ethiopic' => 'Droid Sans Ethiopic (Ethiopic)',
                                                  'EaA_Droid Sans Tamil'    => 'Droid Sans Tamil (Tamil)',
                                                  'EaA_Droid Sans Thai'     => 'Droid Sans Thai (Thai)',
                                                  'EaA_Droid Serif Thai'    => 'Droid Serif Thai (Thai)',
                                                  'EaA_Karla Tamil Inclined'=> 'Karla Tamil Inclined (Tamil)',
                                                  'EaA_Karla Tamil Upright' => 'Karla Tamil Upright (Tamil)',
                                                  'EaA_Lateef'              => 'Lateef (Arabic)',
                                                  'EaA_Lohit Bengali'       => 'Lohit Bengali (Bengali)',
                                                  'EaA_Lohit Devanagari'    => 'Lohit Devanagari (Hindi)',
                                                  'EaA_Lohit Tamil'         => 'Lohit Tamil (Tamil)',
                                                  'EaA_Nanum Brush Script'  => 'Nanum Brush Script (Korean)',
                                                  'EaA_Nanum Gothic'        => 'Nanum Gothic (Korean)',
                                                  'EaA_Nanum Gothic Coding' => 'Nanum Gothic Coding (Korean)',
                                                  'EaA_Nanum Myeongjo'      => 'Nanum Myeongjo (Korean)',
                                                  'EaA_Nanum Pen Script'    => 'Nanum Pen Script (Korean)',
                                                  'EaA_Noto Sans Armenian'  => 'Noto Sans Armenian (Armenian)',
                                                  'EaA_Noto Sans Bengali'   => 'Noto Sans Bengali (Bengali)',
                                                  'EaA_Noto Sans Cherokee'  => 'Noto Sans Cherokee (Cherokee)',
                                                  'EaA_Noto Sans Devanagari'=> 'Noto Sans Devanagari (Hindi)',
                                                  'EaA_Noto Sans Devanagari UI' => 'Noto Sans Devanagari UI (Hindi)',
                                                  'EaA_Noto Sans Georgian'  => 'Noto Sans Georgian (Georgian)',
                                                  'EaA_Noto Sans Hebrew'    => 'Noto Sans Hebrew (Hebrew)',
                                                  'EaA_Noto Sans Kannada'   => 'Noto Sans Kannada (Kannada)',
                                                  'EaA_Noto Sans Lao'       => 'Noto Sans Lao (Lao)',
                                                  'EaA_Noto Sans Lao UI'    => 'Noto Sans Lao UI (Lao)',
                                                  'EaA_Noto Sans Malayalam' => 'Noto Sans Malayalam (malayalam)',
                                                  'EaA_Noto Sans Osmanya'   => 'Noto Sans Osmanya (Osmanya)',
                                                  'EaA_Noto Sans Tamil'     => 'Noto Sans Tamil (Tamil)',
                                                  'EaA_Noto Sans Tamil UI'  => 'Noto Sans Tamil UI (Tamil)',
                                                  'EaA_Noto Sans Telugu'    => 'Noto Sans Telugu (Telugu)',
                                                  'EaA_Noto Sans Thai'      => 'Noto Sans Thai (Thai)',
                                                  'EaA_Noto Sans Thai UI'   => 'Noto Sans Thai UI (Thai)',
                                                  'EaA_Noto Serif Armenian' => 'Noto Serif Armenian (Armenian)',
                                                  'EaA_Noto Serif Georgian' => 'Noto Serif Georgian (Georgian)',
                                                  'EaA_Noto Serif Lao'      => 'Noto Serif Lao (Lao)',
                                                  'EaA_Noto Serif Thai'     => 'Noto Serif Thai (Thai)',
                                                  'EaA_Padauk'              => 'Padauk (Burmese)',
                                                  'EaA_Phetsarath'          => 'Phetsarath (Lao)',
                                                  'EaA_Scheherazade'        => 'Scheherazade (Arabic)',
                                                  'EaA_Souliyo'             => 'Souliyo (Lao)',
                                                  'EaA_Thabit'              => 'Thabit (Arabic)',
                                                  'EaA_Tharlon'             => 'Tharlon (Burmese)' ) );
    
    $fonts_list[] = array(  "id"        => "farsi_group",
                            "title"     => __("RTL fonts", "default"),
                            "faces"     => array('mj_casablanca' => 'casablanca_mj' ) );

    // add filter hook for each fonts group
    foreach ($fonts_list as $key => $list) {
        $fonts_list[$key] = apply_filters( "axiom_get_fonts_list-".$list["id"], $list );
    }

    return apply_filters( "axiom_get_fonts_list", $fonts_list );
}

/*-----------------------------------------------------------------------------------*/
/*  get google fonts name for use in dropdown element 
/*-----------------------------------------------------------------------------------*/

function axi_get_google_font_names(){
    // get all fonts in array
    include(AXI_INC.'options/styling/cache/allfonts.php');
    $g_fonts = unserialize($g_fonts);

    // filter to hook for google fonts
    return apply_filters( "axi_get_google_font_names", $g_fonts );
}

/*-----------------------------------------------------------------------------------*/
/*  get selected (front-end) fonts
/*-----------------------------------------------------------------------------------*/

function axiom_get_selected_fonts(){
    return get_option( THEME_ID. '_selected_fonts' );
}

/*-----------------------------------------------------------------------------------*/
/*  get fontface name in correct format
/*-----------------------------------------------------------------------------------*/

// print font face option by id
function axi_the_fontface($id){
    echo axi_get_fontface($id);
}

    // get font face option by id
    function axi_get_fontface($id){
        global $axiom_options;
        
        $face = $axiom_options[$id];
        // if font name contains upper case, wrap the name in col
        if(axi_is_googlefont($face)){ 
            $face = "'".$face."'"; 
        } elseif (axi_is_earlyaccess_googlefont($face)){ 
            $face = "'".substr($face,4)."'"; 
        }
        
        return $face;
    }

/*-----------------------------------------------------------------------------------*/
/*  returns a string containing the name of special charecters
 *  this method will be called during saving options 
 *  @return e.g: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext
/*-----------------------------------------------------------------------------------*/

function axi_get_name_of_special_charecters(){
    global $axiom_options;
    return isset( $axiom_options["include_latin_chars"] )?'latin,latin-ext':'';
}

/*-----------------------------------------------------------------------------------*/
/*  creates css query for loading selected google fonts, and registers css to enqueue by wp
 *  this function will be called by axi_save_custom_styles
/*-----------------------------------------------------------------------------------*/

function axi_register_custom_gfonts(){
    global $axiom_options;
    
    $selected_faces = array();
    $enq_fonts = array();
    $css_query = '';
    // get list of all google fonts
    $fonts     = axi_get_google_font_names();
    
    // get special charecter sets
    $ext_chars = axi_get_name_of_special_charecters();
    update_option( THEME_ID. '_font_subsets', $ext_chars);
    
    
    // Includes all defined options
    include AXI_INC.'options/axiom-options.php';
    
    // loop through all options and get typography elements
    // then store google fonts in an array ($enq_fonts)
    foreach ($options as $option) {
        if($option['type'] == 'typography'){
            // get stored font name
            $face = isset($axiom_options[$option['id'].'[face]'])?$axiom_options[$option['id'].'[face]']:"";
            
            if(!empty($face)){
                $selected_faces[] = $face; 
                // srore all google fonts in a list
                if(axi_is_googlefont($face)){ $enq_fonts[] = $face; }
            }
        }
    }
    
    // remove duplicated fonts from list
    $enq_fonts      = array_unique($enq_fonts);
    $selected_faces = array_unique($selected_faces);

    foreach ($enq_fonts as $face) {
        // Add seperator for google fonts query
        if(!empty($css_query)){ $css_query .= '|'; }

        $css_query .= str_replace(" ", "+", $face). ':';
        
        // current font object
        $font = $fonts[$face];
        // add font styles to css query
        foreach ($font['styles'] as $style) {
            $css_query .= $style . ',';
        }
        
        substr_replace($css_query, "", -1);
    }
    
    // add special charecter sets to google css query
    if(!empty($ext_chars))
        $css_query .= '&subset=' .$ext_chars;
    
    // You can use this filter hook too change generated css query before saving
    $css_query = apply_filters("axiom_before_storing_css_query", $css_query );

    // store css query as an option
    update_option( THEME_ID. '_cssquery'        , $css_query);
    update_option( THEME_ID. '_selected_fonts'  , $selected_faces);

    do_action("axiom_register_custom_fonts", $enq_fonts, $selected_faces, $fonts );
}

?>