<?php
/**
 * inits option panel
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */

require(AXI_CON.'options/axi-default-options.php');


global $axi_default_options;

require(AXI_INC.'options/styling/functions.php');

require(AXI_INC.'options/axiom-panel-output.php');

require(AXI_INC.'options/axiom-panel-ajax.php');


/*-----------------------------------------------------------------------------------*/
/*	Register Option Page Menu and submenu
/*-----------------------------------------------------------------------------------*/

add_action('admin_menu', 'av3_register_option_page');

function av3_register_option_page(){
	global $submenu;
    
    $menu_name = AXIOM_NO_BRAND? __('Options Panel','default'): __('Theme Options', 'default');
	
	add_menu_page(
	    __('Option Panel','default'),   // [Title]    The title to be displayed on the corresponding page for this menu
		$menu_name,                     // [Text]     The text to be displayed for this actual menu item
		'administrator',				// [User]     Which type of users can see this menu
		'axiom',						// [ID]       The unique ID - that is, the slug - for this menu item
		'axiom_init_options',			// [Callback] The name of the function to call when rendering the menu for this page
		    '',                             // [Icon]     The url to the icon to be used for this menu. This parameter is optional.
		47								// [Position] The position in the menu order this menu should appear
	);

}

//// add some menu to admin bar menu  ///////////////////////////////////////////////////////////////

add_action( 'admin_bar_menu', 'axiom_modify_admin_bar_menu', 999);

function axiom_modify_admin_bar_menu( $wp_admin_bar ) {
    global $wp_admin_bar;
    
    $args = array(
      'id' => 'axiom-theme-options', // id of the existing child node
      'title' => __('Theme Options', 'default'), // alter the title of existing node
      'parent' => "site-name", // set parent node
      'href' => admin_url( 'admin.php?page=axiom' ) // attribute for the link
    );

    $wp_admin_bar->add_node($args);
}

/*-----------------------------------------------------------------------------------*/
/*  Reset option Panel
/*-----------------------------------------------------------------------------------*/

// store default theme options
function axiom_reset_theme_options() {
    global $axi_default_options, $axiom_options;
    
    update_option( THEME_ID.'_options' , $axi_default_options);
    // update current in use theme options
    $axiom_options = format_axiom_options( $axi_default_options);
    // save formatted/usable options
    update_option( THEME_ID.'_formatted_options' , $axiom_options);
}


/*-----------------------------------------------------------------------------------*/
/*  Push default option, if it is not set before
/*-----------------------------------------------------------------------------------*/

// setup and store theme options if this is the first time activition
function axiom_setup_theme_options() {
    
    $th_options = get_option( THEME_ID.'_options');
    
    // temporary command in ver 1.5 -------------------------------------
    $th_formated_options = get_option( THEME_ID.'_formatted_options');
    if(!isset($th_formated_options) || empty($th_formated_options)){
        $f_options = format_axiom_options( $th_options);
        update_option( THEME_ID.'_formatted_options' , $f_options);
    }
    // ------------------------------------------------------------------
    
    if(isset($th_options) && !empty($th_options)) return;
    
    axiom_reset_theme_options();
    add_action('admin_init', 'axi_save_custom_styles' , 12);
}

function axiom_save_styles_on_theme_activation() {
    add_action('admin_init', 'axi_save_custom_styles', 12);
    flush_rewrite_rules();
}

// trigger when theme will be actived, wp 3.3
add_action( 'after_switch_theme', 'axiom_setup_theme_options' );
add_action( 'after_switch_theme', 'axiom_save_styles_on_theme_activation' );

add_action( 'admin_init', 'axiom_setup_theme_options' );

/*-----------------------------------------------------------------------------------*/
/*  Check if custom css file is writable
/*-----------------------------------------------------------------------------------*/

// display notice if user need to set permission for directory
function axiom_notice_custom_css_permission(){
    $css_file  = get_template_directory() . '/css/other';
    
    echo '<div class="updated">
       <p>'.__("This theme needs permission to write custom styles in css file.Please change directory permission at ( [current_theme]/css/other ) to 644 or higher","default").'</p>
       <p>'.__("If you changed the permission and still see this message follow the instructions here.", "default").' <a href="http://themeforest.net/item/lotus-flexible-multipurpose-responsive-wp-theme/3909293/faqs/14219">'.__("the solution","default").'</a></p>
       <p>'.__("File system method is :", "default").' '.get_filesystem_method(array(), $css_file) .'</p>
    </div>';
}

function axiom_check_custom_css_writable() {
    
    $css_file  = get_template_directory() . '/css/other';
    if(!axiom_is_dir_writable($css_file)){
        //add_action('admin_notices', 'axiom_notice_custom_css_permission');
        
        if(!function_exists('get_filesystem_method')) echo '"get_filesystem_method" function does not exist.<br />';
    }
}
add_action( 'admin_init', 'axiom_check_custom_css_writable' );


/*-----------------------------------------------------------------------------------*/
/*  This fuction passes all defined option sections through filter hook. 
/*  We can change options in each section by using "axiom_options_in_section_{section_name}" filter
/*  (section is group of options in each tab on option panel)
/*  Note: Be careful not to remove any defined option just add your prefered ones 
/*-----------------------------------------------------------------------------------*/

function axiom_pass_options_through_filter_hooks($options){
    $filtered_options   = array();
    // section is group of options in each tab on option panel
    $section            = array();
    foreach ($options as $option) {
        // collect options for current section until reaching to the end of section
        
        if($option['type'] == 'end'){
            // now we reached to end of section, it's time to hook for options on this section
            if(isset($option['section']))
                $section = apply_filters( 'axiom_options_in_section_'.$option['section'], $section );
            // now add end tag too
            $section[] = $option;
            // add filtered options to options list
            $filtered_options = array_merge($filtered_options ,$section);
            // reset to collect options for next section
            $section = array();
        }else {
            $section[] = $option;
        }
    }
    return $filtered_options;
}


?>