<?php 

/*-----------------------------------------------------------------------------------*/
/*  Add Page Builder
/*-----------------------------------------------------------------------------------*/
include( AXI_INC.'modules/builder/index.php');

/*-----------------------------------------------------------------------------------*/
/*  Add Image Resize
/*-----------------------------------------------------------------------------------*/
require_once( AXI_INC.'modules/lib/aq_resizer.php');

/*-----------------------------------------------------------------------------------*/
/*  Include the TGM_Plugin_Activation class
/*-----------------------------------------------------------------------------------*/
require_once( AXI_INC.'modules/lib/class-tgm-plugin-activation.php');

/*-----------------------------------------------------------------------------------*/
/*  Add Layer Slider
/*-----------------------------------------------------------------------------------*/

function axiom_include_layerslider(){
    
    if( !apply_filters("axiom_include_layerslider", true) ) return;
    
    
    // Path for LayerSlider WP main PHP file
    $layerslider = AXI_INC . 'modules/LayerSlider/layerslider.php';
    
    // Check if the file is available to prevent warnings
    if(file_exists($layerslider)) {
     
        // Include the file
        include $layerslider;
        
        $layerslider_last_version = get_option('layerslider_last_version', '1.0');
        if(get_option(THEME_ID.'_layerslider_activated', '0') == '0'){
            layerslider_activation_scripts();
            update_option(THEME_ID.'_layerslider_activated', '1');
            update_option('layerslider_last_version', $GLOBALS['lsPluginVersion']);}
        else if(version_compare($GLOBALS['lsPluginVersion'], $layerslider_last_version, '>')){
            layerslider_activation_scripts();
            update_option('layerslider_last_version', $GLOBALS['lsPluginVersion']);}
    }
    
    
    // Register your custom function to override some LayerSlider data
    add_action('layerslider_ready', 'axi_layerslider_overrides');
    
    
    // Define your function
    function axi_layerslider_overrides() {
        // Items to override
        $GLOBALS['lsPluginPath']    = AXI_INC_URL . 'modules/LayerSlider/';
        $GLOBALS['lsAutoUpdateBox'] = false;
    }

}

//axiom_include_layerslider();

/*-----------------------------------------------------------------------------------*/
/*  Turn off Layer slider auto update feature
/*-----------------------------------------------------------------------------------*/

// Define your function
function axi_layerslider_config() {
    // Items to override
    $GLOBALS['lsAutoUpdateBox'] = false;
}

// Register your custom function to override some LayerSlider data
add_action('layerslider_ready', 'axi_layerslider_config');

/*-----------------------------------------------------------------------------------*/
/*  Add Cute Slider
/*-----------------------------------------------------------------------------------*/

function axiom_include_cuteslider(){
    
    if( !apply_filters("axiom_include_cuteslider", true) ) return;
    
    
    // Path for Cute Slider WP main PHP file
    $cuteslider = AXI_INC . 'modules/CuteSlider/cuteslider.php';
     
    // Check if the file is available to prevent warnings
    if(file_exists($cuteslider)) {
     
        // Include the file
        include $cuteslider;
     
        // Activate the plugin if necessary
        if(get_option(THEME_ID . '_cuteslider_activated', '0') == '0') {
     
            // Run activation script
            cuteslider_activation_scripts();
     
            // Save a flag that it is activated, so this won't run again
            update_option(THEME_ID . '_cuteslider_activated', '1');
        }
    }
    
    $GLOBALS['csPluginVersion'] = '1.1.0';
    $GLOBALS['csPluginPath'] = AXI_INC_URL . 'modules/CuteSlider';
     
    // Activation hook for creating the initial DB table
    register_activation_hook(__FILE__, 'cuteslider_activation_scripts');
    
}

//axiom_include_cuteslider();

/*-----------------------------------------------------------------------------------*/

?>
