<?php 
/**
 * Axiom is powerful dedicated framework for averta themes
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @link       http://www.averta.net
 */

/*-----------------------------------------------------------------------------------*/
/*  Define general constants
/*-----------------------------------------------------------------------------------*/
require_once('init/const.php');

/*-----------------------------------------------------------------------------------*/
/*  Inculde essential functions
/*-----------------------------------------------------------------------------------*/
require_once('init/global.php');

/*-----------------------------------------------------------------------------------*/
/*  Theme specific functions and configs
/*-----------------------------------------------------------------------------------*/
include( AXI_CON.'include/index.php');

/*-----------------------------------------------------------------------------------*/
/*	Setup general configs
/*-----------------------------------------------------------------------------------*/
require_once('init/configs.php');

/*-----------------------------------------------------------------------------------*/
/*  Include global functions
/*-----------------------------------------------------------------------------------*/
do_action("axiom_before_functions");

require_once( AXI_INC.'include/functions.php');

do_action("axiom_after_functions");

/*-----------------------------------------------------------------------------------*/
/*  Include general settings
/*-----------------------------------------------------------------------------------*/
do_action("axiom_before_setting");

require_once( AXI_INC.'include/setting.php');

/*-----------------------------------------------------------------------------------*/
/*  Inculde classes
/*-----------------------------------------------------------------------------------*/
require_once('classes/index.php');

do_action("axiom_classes_loaded");

/*-----------------------------------------------------------------------------------*/
/*	Register required assets (scripts & styles)
/*-----------------------------------------------------------------------------------*/
if(is_admin())
require_once('init/assets-admin.php');

/*-----------------------------------------------------------------------------------*/
/*  Add Shortcodes
/*-----------------------------------------------------------------------------------*/
do_action("axiom_before_shortcodes");

include( AXI_INC.'shortcodes/index.php');

do_action("axiom_after_shortcodes");

/*-----------------------------------------------------------------------------------*/
/*	Register Post-Types
/*-----------------------------------------------------------------------------------*/
do_action("axiom_before_posttypes");

include( AXI_INC.'post-types/index.php');

do_action("axiom_after_posttypes");

/*-----------------------------------------------------------------------------------*/
/*  Add Modules
/*-----------------------------------------------------------------------------------*/
include( AXI_INC.'modules/index.php');

do_action("axiom_ready");

/*-----------------------------------------------------------------------------------*/
/*  Widgets and sidebars
/*-----------------------------------------------------------------------------------*/
include( AXI_INC.'sidebars/index.php');

/*-----------------------------------------------------------------------------------*/
/*  Compatibility for third party plugins
/*-----------------------------------------------------------------------------------*/
include( AXI_INC.'compatibility/index.php');

/*-----------------------------------------------------------------------------------*/
/*	Init Option Panel
/*-----------------------------------------------------------------------------------*/
if(is_admin())
include( AXI_INC.'options/index.php');

/*-----------------------------------------------------------------------------------*/
/*  
/*-----------------------------------------------------------------------------------*/
do_action("axiom_loaded");
if(is_admin())
do_action("axiom_admin_loaded");

?>