<?php
/**
 * General functions here
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */


/*-----------------------------------------------------------------------------------*/
/*  Setup Header 
/*-----------------------------------------------------------------------------------*/

function axiom_after_setup_theme(){
    global $axiom_support;
    
    if ( function_exists( 'add_theme_support' ) ) {
        
        // add post thumbnails for custom post tyoes
        add_theme_support( 'post-thumbnails' , apply_filters( "axiom_post_thumbnails" , array( 'post', 'page', 'portfolio', 'axi_product', 'news', 'staff', 'testimonial')) );
        set_post_thumbnail_size( 280, 180, true ); // Featured image display size
        
        /*  Add Post Formats
        /*-------------------------------------------------------------------------*/
        if( in_array( 'post-formats', $axiom_support ) )
            add_theme_support( 'post-formats', apply_filters( 'axiom_post_formats', array( 'aside', 'gallery', 'image', 'link', 'quote', 'video', 'audio' ) ) );
        
        
        /*  Adds RSS feed links to <head> for posts and comments.
        /*-------------------------------------------------------------------------*/
        if( in_array( 'automatic-feed-links', $axiom_support ) )
            add_theme_support( 'automatic-feed-links' );
        
        
        /*  Declare WooCommerce support
        /*-------------------------------------------------------------------------*/
        if( in_array( 'woocommerce', $axiom_support ) )
            add_theme_support( 'woocommerce' );
    }
    
    
    /*  Config excerpts length
    /*------------------------------------------------------------------------------*/
    add_filter( 'excerpt_length'  , 'av3_excerpt_length' );
    add_filter( 'excerpt_more'    , 'av3_auto_excerpt_more' );
    
    // gererate shortcodes in widget text
    add_filter('widget_text', 'do_shortcode');
    //add_filter( 'get_the_excerpt' , 'av3_custom_excerpt_more' );
    
    //remove_filter('get_the_excerpt', 'wp_trim_excerpt');
    //add_filter( 'get_the_excerpt', 'axiom_get_the_trim_excerpt');
    //add_filter( 'get_the_excerpt', 'do_shortcode' );
    
    /*  Make theme available for translation
    /*------------------------------------------------------------------------------*/
    /* Translations can be added to the /languages/ directory. */
    if( ! load_theme_textdomain( 'default', get_stylesheet_directory() . '/languages' ) )
          load_theme_textdomain( 'default', get_template_directory()   . '/languages' );
        
    // increase the memory to 256 MB
    ini_set("memory_limit","256M");
}

add_action( 'after_setup_theme', 'axiom_after_setup_theme' );


global $pagenow;
// redirect to welcome page after theme activation
if ( isset( $_GET['activated'] ) && $pagenow == "themes.php"){
    wp_redirect( admin_url('admin.php?page=lotus') );
}

/*-----------------------------------------------------------------------------------*/
/*  Declare nav menu
/*-----------------------------------------------------------------------------------*/

if(!function_exists("axiom_declare_nav_menu")){
    
    function axiom_declare_nav_menu(){
        
        /*  Register Theme menus
        /*------------------------------------------------------------------------------*/
        if( has_nav_menu('primary')) unregister_nav_menu('primary'); 
        
        // Adds Header menu
        register_nav_menu( 'primary' , __( 'Header Navigation', 'default' ) );
        
        // adds Footer menu
        register_nav_menu( 'footer'  , __( 'Footer Navigation', 'default' ) );
        
    }
}

add_action( 'after_setup_theme', 'axiom_declare_nav_menu' );



/*-----------------------------------------------------------------------------------*/
/*  Dashboard "Right Now" modification
/*-----------------------------------------------------------------------------------*/

if(!function_exists("axiom_add_posttypes_2_rightnow")){
    
    function axiom_add_posttypes_2_rightnow() {    
        $post_types = get_post_types( array( '_builtin' => false ), 'objects' ); 
        $known_post_types = array("portfolio", "axi_product", "news", 'faq', 'pricetable');
        
        if (count($post_types) > 0)
        foreach( $post_types as $pt => $args ) {
            if(!in_array($pt, $known_post_types)) continue;
            $url = 'edit.php?post_type='.$pt;
            echo '<tr><td class="b"><a href="'. $url .'">'. wp_count_posts( $pt )->publish .'</a></td><td class="t"><a href="'. $url .'">'. $args->labels->name .'</a></td></tr>';
        }
        echo "";
    }  

}

add_action( 'right_now_content_table_end', 'axiom_add_posttypes_2_rightnow' );


if(!function_exists("axiom_add_2_rightnow_bottom")){
    
    function axiom_add_2_rightnow_bottom() {    
        $theme   = wp_get_theme();
        $p_theme = axiom_get_main_theme();
        printf( __('You are using <strong><a href="themes.php">%1$s</a></strong> theme <strong>version %2$s</strong>', 'default'), $theme->display('Name'),$p_theme->display('Version') );
    }  

}

add_action( 'rightnow_end', 'axiom_add_2_rightnow_bottom' );


/*-----------------------------------------------------------------------------------*/
/*  Get data about current main(parent) theme 
/*-----------------------------------------------------------------------------------*/

function axiom_get_main_theme(){
    $theme = wp_get_theme();
    // always use parent theme data - averta
    if(is_child_theme()) 
        $theme = wp_get_theme($theme->template);
    return $theme;
}


/*-----------------------------------------------------------------------------------*/
/*  Add some user contact fields
/*-----------------------------------------------------------------------------------*/

function axiom_user_contactmethods($user_contactmethods){
  $user_contactmethods['twitter']    = __('Twitter'    , 'default');
  $user_contactmethods['facebook']   = __('Facebook'   , 'default');
  $user_contactmethods['googleplus'] = __('Google Plus', 'default');
  $user_contactmethods['flickr']     = __('Flickr'     , 'default');
  $user_contactmethods['delicious']  = __('Delicious'  , 'default');
  $user_contactmethods['pinterest']  = __('Pinterest'  , 'default');
  $user_contactmethods['github']     = __('GitHub'     , 'default');
  $user_contactmethods['skills']     = __('Skills'     , 'default');
  
  return apply_filters("axiom_user_contactmethods", $user_contactmethods);
}

add_filter('user_contactmethods', 'axiom_user_contactmethods');

/*-----------------------------------------------------------------------------------*/
/*  Redirect portfolio single page if redirect url is set
/*-----------------------------------------------------------------------------------*/

    
function axiom_filter_portfolio_the_permalink($permalink){
    global $post;
    
    if ( isset($post) && get_post_type($post->ID) == "portfolio"){
        $redirect_url = get_post_meta($post->ID, "portfolio-redirect-url", true);
        if(!empty($redirect_url)) 
            return $redirect_url;
    }
    return $permalink;
}

add_filter("the_permalink", "axiom_filter_portfolio_the_permalink", 10, 1);


/*-----------------------------------------------------------------------------------*/
/*  Front end query modifications
/*-----------------------------------------------------------------------------------*/

function axiom_front_end_update_query( $query ) {
    if ( is_admin() || ! $query->is_main_query() )
        return;
    
    
    if (is_post_type_archive('portfolio')){
        $perpage = axiom_option("portfolio_index_page_items_perpage");
        $perpage = (int)$perpage < 1?-1:$perpage;
        
        $query->set( 'posts_per_page', $perpage );
        return;
    }
    
    if ( $query->is_tax('project-type') || $query->is_tax('portfolio-tag') ) {
        $perpage = axiom_option("portfolio_category_page_items_perpage");
        $perpage = (int)$perpage < 1?-1:$perpage;
        
        $query->set( 'posts_per_page', $perpage );
        return;
    }
    
    if ( is_post_type_archive('axi_product') ) {
        $perpage = axiom_option("product_index_page_items_perpage");
        $perpage = (int)$perpage < 1?-1:$perpage;
        
        $query->set( 'posts_per_page', $perpage );
        return;
    }
    
    if ( $query->is_tax('product-category') || $query->is_tax('product-tag') ) {
        $perpage = axiom_option("product_category_page_items_perpage");
        $perpage = (int)$perpage < 1?-1:$perpage;
        
        $query->set( 'posts_per_page', $perpage );
        return;
    }
    
    if ( is_post_type_archive('news') ) {
        $query->set( 'orderby', 'menu_order date' );
        return;
    }
    
    if ( $query->is_tax('news-category') || $query->is_tax('news-tag') ) {
        $query->set( 'orderby', 'menu_order date' );
        return;
    }
    
    if ( is_post_type_archive('service') ) {
        $query->set( 'posts_per_page', 12 );
        return;
    }
    
    if ( $query->is_tax('service-category') ) {
        $query->set( 'posts_per_page', 12 );
        return;
    }
    
    if ( is_post_type_archive('faq') ) {
        $query->set( 'posts_per_page', 30 );
        return;
    }
    
    if ( $query->is_tax('faq-category') ) {
        $query->set( 'posts_per_page', 20 );
        return;
    }
    
    if ( is_post_type_archive('staff') ) {
        $query->set( 'posts_per_page', 12 );
        return;
    }
    
    if ( $query->is_tax('departman') ) {
        $query->set( 'posts_per_page', 12 );
        return;
    }
    
    if ( is_post_type_archive('testimonial') ) {
        $query->set( 'posts_per_page', 20 );
        return;
    }
    
    // Filter Search and only display results from main post types
     if ($query->is_search) {
        $query->set( 
            'post_type', array( 'page', 'post', 'portfolio', 'axi_product', 'staff', 'service', 'testimonial', 'news', 'faq' )
        );
        return;
    }
    
}
add_action( 'pre_get_posts', 'axiom_front_end_update_query', 1 );

/*-----------------------------------------------------------------------------------*/
/*  Remove all auto generated p tags & line breaks beside shortcode content
/*-----------------------------------------------------------------------------------*/

function axiom_cleanup_beside_shortcodes($content){   
    $array = array (
        '<p>['    => '[', 
        ']</p>'   => ']', 
        ']<br />' => ']'
    );
    $content = strtr($content, $array);
    return $content;
}

add_filter('the_content', 'axiom_cleanup_beside_shortcodes');


/*-----------------------------------------------------------------------------------*/
/*  Filtering wp_title to improve seo and letting seo plugins to filter the output too 
/*-----------------------------------------------------------------------------------*/

function axiom_wp_title($title, $sep, $seplocation) {
    global $page, $paged, $post;
    
    // Don't affect feeds
    if ( is_feed() )  return $title;
    
    // Add the blog name
    if ( 'right' == $seplocation )
        $title  .= get_bloginfo( 'name' );
    else
        $title   = get_bloginfo( 'name' ) . $title;
    
    // Add the blog description for the home/front page
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) ){
        $title .= " $sep $site_description";
    }
    
    // Add a page number if necessary
    if ( $paged >= 2 || $page >= 2 ){
        $title .= " $sep " . sprintf( __( 'Page %s', 'default' ), max( $paged, $page ) );
    }
    
    return $title;
}

if( ! defined('WPSEO_VERSION') )
add_filter( 'wp_title', 'axiom_wp_title', 10, 3 );

/*-----------------------------------------------------------------------------------*/
/*  add excerpts to pages
/*-----------------------------------------------------------------------------------*/

function axiom_add_excerpts_to_pages() {
     add_post_type_support( 'page', 'excerpt' );
}

add_action( 'init', 'axiom_add_excerpts_to_pages' );

/*-----------------------------------------------------------------------------------*/
/*  load custom google fonts
/*-----------------------------------------------------------------------------------*/

// register google fonts
function axi_register_google_fonts_styles(){
    global $axiom_options;
    
    // get stored css query
    $css_query = get_option( THEME_ID. '_cssquery');
    
    $protocol = is_ssl() ? 'https' : 'http';
    $query_args = array(
        'family' => $css_query
    );
    
    if(!empty($css_query) && isset($axiom_options["enable_custom_typography"]) ){
        wp_register_style( 'custom_typography', add_query_arg( $query_args, "$protocol://fonts.googleapis.com/css" ), array(), null );
    }elseif(axi_is_script_registered('custom_typography')){
        wp_deregister_style('custom_typography');
    }
}

add_action('wp_enqueue_scripts', 'axi_register_google_fonts_styles', 1 );

/*-----------------------------------------------------------------------------------*/
/*  Print meta tags to preview post while sharing on facebook
/*-----------------------------------------------------------------------------------*/

function axiom_facebook_header_meta (){
    // return if built-in seo is disabled or "SEO by yoast" is active
    if( axiom_option('disable_theme_seo') || defined('WPSEO_VERSION') || class_exists('All_in_One_SEO_Pack') ) return;
    
    global $post;
    if( ! isset( $post ) || ! is_singular() || is_search() || is_404() ) return;
    setup_postdata( $post );

    $featured_image = axiom_get_the_post_thumbnail_src($post->ID, 90, 90, true, 90);
    $post_excerpt   = get_the_excerpt();
    ?>
<meta name="title"       content="<?php echo esc_attr( $post->post_title ); ?>" /> 
<meta name="description" content="<?php echo esc_attr( $post_excerpt ); ?>" />
<?php if( $featured_image) { ?>
<link rel="image_src"    href="<?php echo $featured_image; ?>" />
<?php }

}

add_action( 'wp_head', 'axiom_facebook_header_meta' );

/*-----------------------------------------------------------------------------------*/
/*  Apply shortcodes to widgets 
/*-----------------------------------------------------------------------------------*/

add_filter( 'widget_text', 'do_shortcode');
add_filter( 'the_excerpt', 'do_shortcode');

/*-----------------------------------------------------------------------------------*/
/*  Modify Admin menu
/*-----------------------------------------------------------------------------------*/

function remove_menus () {
global $menu;
    $restricted = array(__('Posts'), __('Comments'));
    end ($menu);
    while (prev($menu)){
        $value = explode(' ',$menu[key($menu)][0]);
        if(in_array($value[0] != NULL?$value[0]:"" , $restricted)){unset($menu[key($menu)]);}
    }
}
//add_action('admin_menu', 'remove_menus');

/*-----------------------------------------------------------------------------------*/
/*  assigns theme custom post types capabilities to main roles
/*-----------------------------------------------------------------------------------*/

function axiom_assign_default_caps_for_post_types() {
    global $axiom_active_post_types;
    
    // the roles to add capabilities of custom post types to
    $roles = array('administrator', 'editor');
    foreach ($roles as $role_name) {
        
        $role = get_role( $role_name );
        if(!isset($role)) continue;

        // loop through custom post types and add custom capabilities to defined rules
        foreach ($axiom_active_post_types as $post_type => $enabled) {
            if( !$enabled || !post_type_exists($post_type))   continue;
            
            $post_type_object = get_post_type_object($post_type);
            // add post type capabilities to role
            foreach ($post_type_object->cap as $cap_key => $cap) { 
                if(!in_array($cap_key, array('edit_post', 'delete_post', 'read_post') ))
                    $role->add_cap( $cap );
            }
        }
    }
}

/*-----------------------------------------------------------------------------------*/
/*  the function runs when axiom framework loaded 
/*-----------------------------------------------------------------------------------*/

function axiom_on_axiom_fw_admin_loaded(){
    
    // assign theme custom capabilities to roles on first run
    if(!get_option('is_'.THEME_ID.'_caps_assigned')){
        add_action('admin_init'  , 'axiom_assign_default_caps_for_post_types');
        update_option('is_'.THEME_ID.'_caps_assigned', 1);
    }
}

add_action('axiom_admin_loaded', 'axiom_on_axiom_fw_admin_loaded');

/*-----------------------------------------------------------------------------------*/
/*  Include the Welcome page
/*-----------------------------------------------------------------------------------*/

function axion_register_theme_menu() {

    $root_menu_name = __( 'Lotus', THEME_DOMAIN );
    $root_menu_name = apply_filters( 'auxin_theme_setting_menu_name', $root_menu_name );

    $welcome_root_slug = 'lotus';


    /*  Register root setting menu
    /*------------------------------------------------------------------------*/
    add_menu_page(
        $root_menu_name,                                // [Title]    The title to be displayed on the corresponding page for this menu
        $root_menu_name,                                // [Text]     The text to be displayed for this actual menu item
        apply_filters( 'auxin_theme_welcome_capability', 'manage_options' ),
                                                        // [User]     Which type of users can see this menu
        $welcome_root_slug,                             // [ID/slug]  The unique ID - that is, the slug - for this menu item
        array( Auxin_About::get_instance(), 'render'),  // [Callback] The name of the function to call when rendering the menu for this page
        '',                                             // icon_url
        3                                               // [Position] The position in the menu order this menu should appear 3 means after dashboard
    );

    /*  Add a menu separator
    /*------------------------------------------------------------------------*/
    add_menu_page(
        '',                                             // [Title]    The title to be displayed on the corresponding page for this menu
        '',                                             // [Text]     The text to be displayed for this actual menu item
        'read',                                         // [User]     Which type of users can see this menu
        'wp-menu-separator',                            // [ID/slug]  The unique ID - that is, the slug - for this menu item
        '',                                             // [Callback] The name of the function to call when rendering the menu for this page
        '',                                             // icon_url
        4                                               // [Position] The position in the menu order this menu should appear 3 means after dashboard
    );

}

add_action( 'admin_menu', 'axion_register_theme_menu' );








/*-----------------------------------------------------------------------------------*/
/*  Adds welcome tab in theme about (welcome) page
/*-----------------------------------------------------------------------------------*/

function auxin_welcome_page_display_section_features(){
    ?>
    <div class="auxin-welcome">
        <div class="welcome-inner">
	        <section>
	           <h3>Background</h3>
	           <p>As you may know, Lotus theme was released in 2013 and during these years, this theme has been updated constantly in order to meet the latest standards and web technologies.</p>
	           <p>Among these years, we received huge number of positive and heartwarming feedbacks which made us even more motivated and pushed us forward to improve Lotus theme persistently.</p>
	        </section>
	        <section>
	           <h3>The Plan</h3>
	           <p>In 2016, we planned for huge improvements in Lotus theme and worked so hard over a year to make this dream happen. As a result, the Lotus was architected from scratch in order to make a versatile and modern theme for 2017 and the years to come.</p>
	        </section>
	        <section>
	           <h3>A Massive Update</h3>
	           <p>While Lotus was redesigned and coded from ground up, and enormous changes have been applied, we considered a new name for this project. It’s called <span title="Lotus theme version 6">Phlox</span>! </p>
	        </section>
	        <section>
	           <h3>What is Phlox?</h3>
	           <p>Phlox is the name for the new generation of Lotus theme. In other words, Phlox is the biggest update in the history of Lotus theme, we call it Lotus version 6! </p>
	        </section>

	        <section>
	           <h3>Phlox Compatibility with Lotus?</h3>
	           <p>While Lotus theme was completely recreated from scratch, some legacy features and elements/widgets were dropped and no longer are supported in <span title="Lotus theme version 6">Phlox</span>. As a result, at the moment the <span title="Lotus theme version 6">Phlox</span> theme is partially compatible with Lotus. We are working so hard to implement new substitution and modern elements to make it completely compatible with Lotus.</p>
	        </section>
	        <section>
	           <h3>Phlox Release Date?</h3>
	           <p>Hopefully, we are at the end of our roadmap. The initial version of <span title="Lotus theme version 6">Phlox</span> (beta version) should be available at the end of June. </p>
	        </section>
	        <section>
	           <h3>Can I roll back to Lotus after Trying Phlox?</h3>
	           <p>Yes. Fortunately, the <span title="Lotus theme version 6">Phlox</span> will be released as a separate project (theme), so you can have both Lotus and Phlox theme at the same time on your website which makes you able to switch to <span title="Lotus theme version 6">Phlox</span> with a single click. Anyone who is the owner of the Lotus theme can switch to <span title="Lotus theme version 6">Phlox</span> and try it. Your data is SAFE in the database and switching to <span title="Lotus theme version 6">Phlox</span> does NOT affect or damage your data.</p>
	        </section>
	        <section>
	           <h3>What happens to Lotus?</h3>
	           <p>We love the Lotus theme as you do! So we continue to support and release minor updates for legacy Lotus theme in parallel to <span title="Lotus theme version 6">Phlox</span>. But we highly recommend you to migrate to the new generation of Lotus (<span title="Lotus theme version 6">Phlox</span>) in order to take your website to the next level. </p>
	        </section>
	        <section>
	           <h3>Where Can I Post My Feedback? </h3>
	           <p>We considered a dedicated service for you to post your feedback in. We love to hear from you and your worthwhile feedback will help us to improve <span title="Lotus theme version 6">Phlox</span> theme better and faster. Please post your feedbacks here: ( The feedback link will be available on release date of Phlox; at the moment, you can contact us via email : <?php echo antispambot( 'lotus@averta.net' ); ?> )</p>
	        </section>
	        <section>
	           <h3>Phlox Pricing?</h3>
	           <p>It’s totally <strong>free</strong> for our lovely owner of Lotus theme.</p>
	        </section>
      	</div>
    </div>
    <?php
}

function auxin_welcome_add_section_features( $sections ){

    $sections['features'] = array(
        'label'       => __( 'Welcome', THEME_DOMAIN ),
        'description' => __( 'A Flexible and Multipurpose solution for all seasons.', THEME_DOMAIN ),
        'callback'    => 'auxin_welcome_page_display_section_features'
    );

    return $sections;
}

add_filter( 'auxin_admin_welcome_sections', 'auxin_welcome_add_section_features', 20 );


/*-----------------------------------------------------------------------------------*/
/*  Adds customize tab in theme about (welcome) page
/*-----------------------------------------------------------------------------------*/

function auxin_welcome_add_section_customize( $sections ){

    $sections['customize'] = array(
        'label'       => __( 'Theme Options', THEME_DOMAIN ),
        'description' => '',
        'url'         => admin_url( 'admin.php?page=axiom' ), // optional
    );

    return $sections;
}

add_filter( 'auxin_admin_welcome_sections', 'auxin_welcome_add_section_customize', 70 );


