<?php
/**
 * General functions here
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */

global $axiom_options;


//// verfiy current page id ////////////////////////////////////////////////////////////

if( ! function_exists("is_currentpage_id") ){
    
    function is_currentpage_id($id){
        if( ! function_exists("get_current_screen"))    return true;
        
        $screen = get_current_screen();
        $res = (is_object($screen) && $screen->id == $id)?TRUE:FALSE;
        return $res;
    }
    
}

//// is absolute url ///////////////////////////////////////////////////////////////////

if( ! function_exists("axiom_is_absolute_url") ){
    
    function axiom_is_absolute_url($url){
        return preg_match("~^(?:f|ht)tps?://~i", $url);
    }
    
}

//// finds out if the url contains upload directory path (true, if it's absolute url to internal file)

if( ! function_exists("axiom_contains_upload_dir") ){
    
    function axiom_contains_upload_dir($url){
        $uploads_dir = wp_upload_dir();
        return strpos($url, $uploads_dir['baseurl']) !== false;
    }
    
}

//// create absolute url if the url is relative ////////////////////////////////////////

function axiom_the_absolute_image_url($url){
    echo axiom_get_the_absolute_image_url($url);
}

    if( ! function_exists("axiom_get_the_absolute_image_url") ){
        
        function axiom_get_the_absolute_image_url($url){
            if( !isset($url) || empty($url) )    return "";
            
            if(axiom_is_absolute_url($url)) return $url;
            
            $uploads = wp_upload_dir();
            return $uploads['baseurl']. '/' .$url;
        }
    
    }

//// create relative url if it's url for internal uploaded file ////////////////////////

function axiom_the_relative_file_url($url){
    echo axiom_get_the_relative_file_url($url);
}

    if( ! function_exists("axiom_get_the_relative_file_url") ){
        
        function axiom_get_the_relative_file_url($url){
            if( !isset($url) || empty($url) )    return "";
            
            // if it's not internal absolute url 
            if(!axiom_contains_upload_dir($url)) return $url;
            
            $uploads_dir = wp_upload_dir();
            return str_replace($uploads_dir['baseurl']."/", "", $url);
        }
    
    }


//// check if a value exists in an array //////////////////////////////////////////////

if( ! function_exists("axiom_is_in_array") ){
    
    function axiom_is_in_array($value, $array){
        if(!is_array($array) || !isset($value) )    return false;
        
        return in_array($value, $array);
    }

}

//// get all registerd siderbar ids ///////////////////////////////////////////////////

if( ! function_exists("axiom_get_all_sidebar_ids") ){
    
    function axiom_get_all_sidebar_ids(){
        $sidebars = get_option( THEME_ID.'_sidebars');
        $output   = array();
        
        if(isset($axiom_sidebars)  && !empty($axiom_sidebars) ){
            foreach($sidebars as $key => $value) {
                $output[] = THEME_ID .'-'. strtolower(str_replace(' ', '-', $value));
            }
        }
        return $output;
    }

}

//// remove all p tags from string ////////////////////////////////////////////////////

if( ! function_exists("axiom_cleanup_content") ){
    
    function axiom_cleanup_content( $content ) { 
     
        /* Remove any instances of '<p>' '</p>'. */ 
        $content = str_replace( array( '<p>'  ), '', $content ); 
        $content = str_replace( array( '</p>' ), '', $content ); 
        
        return $content; 
    } 

}

//// remove all auto generated p tags from shortcode content //////////////////////////

if( ! function_exists("axiom_do_cleanup_shortcode") ){
    
    function axiom_do_cleanup_shortcode( $content ) { 
     
        /* Parse nested shortcodes and add formatting. */ 
        $content = trim( wpautop( do_shortcode( $content ) ) ); 
     
        /* Remove any instances of '<p>' '</p>'. */ 
        $content = axiom_cleanup_content( $content );
        
        return $content; 
    }

}

/*-----------------------------------------------------------------------------------*/
/*  Get trimmed string
/*-----------------------------------------------------------------------------------*/

function axiom_the_trimmed_string($string, $max_length = 1000, $more = " ..."){
    echo axiom_get_trimmed_string( $string, $max_length, $more );
}
    
    if( ! function_exists("axiom_get_trimmed_string") ){
        function axiom_get_trimmed_string($string, $max_length = 1000, $more = " ..."){
            return function_exists("mb_strimwidth")?mb_strimwidth( $string, 0, $max_length, $more ):substr($string, 0, $max_length).$more;
        }
    }

/*-----------------------------------------------------------------------------------*/
/*  Shortcode enabled excerpts trimmed by character length
/*-----------------------------------------------------------------------------------*/

function axiom_the_trim_excerpt($post_id = null, $char_length = null, $exclude_strip_shortcode_tags = null){
    echo axiom_get_the_trim_excerpt($post_id, $char_length, $exclude_strip_shortcode_tags);
}

    if( ! function_exists("axiom_get_the_trim_excerpt") ){
        
        // make shortcodes executable in excerpt
        function axiom_get_the_trim_excerpt($post_id = null, $char_length = null, $exclude_strip_shortcode_tags = null) {
            $post = get_post($post_id);
            if(!isset($post)) return "";
            
    
            $excerpt = $post->post_content;
            $excerpt = apply_filters('the_content', $excerpt);
            // If char length is defined use it, otherwise use default char length
            $char_length  = empty($char_length)?apply_filters('axiom_excerpt_char_length', 250):$char_length;
            $excerpt_more = apply_filters('excerpt_more', ' ...');
            // Clean post content
            $excerpt = strip_tags( axiom_strip_shortcodes($excerpt, $exclude_strip_shortcode_tags) );
            return     axiom_get_trimmed_string($excerpt, $char_length, $excerpt_more);
        }
        
    }

/*-----------------------------------------------------------------------------------*/
/*  Excerpt outside of loop - trimmed by word length - The shortcodes content remains after striping
/*-----------------------------------------------------------------------------------*/

function axiom_the_excerpt($post_id = null, $excerpt_length = null, $exclude_strip_shortcode_tags = null){
    echo axiom_get_the_excerpt($post_id, $excerpt_length, $exclude_strip_shortcode_tags);
}
    
    // Generates an excerpt from the content outside of loop, if needed.
    function axiom_get_the_excerpt($post_id = null, $excerpt_length = null, $exclude_strip_shortcode_tags = null) {
        $post = get_post($post_id);
        if(!isset($post)) return "";
        
        if ( post_password_required() ) {
            return __( 'There is no excerpt because this is a protected post.' );
        }
        
        if ($post->post_excerpt) {
            $resault = apply_filters( 'get_the_excerpt', $post->post_excerpt );
        }
        else {
            $excerpt = $post->post_content;
            $excerpt = apply_filters('the_content', $excerpt);
            // If excerpt length is defined use it, otherwise use default excerpt length
            $excerpt_length = empty($excerpt_length)?apply_filters('excerpt_length', 55):$excerpt_length;
            $excerpt_more   = apply_filters('excerpt_more', ' ...');
            // Clean post content
            $excerpt = strip_tags( axiom_strip_shortcodes($excerpt, $exclude_strip_shortcode_tags) );
            $resault = wp_trim_words( $excerpt, $excerpt_length, $excerpt_more);
        }
        return apply_filters('axiom_get_the_excerpt', $resault);
    }

/*-----------------------------------------------------------------------------------*/
/*  Remove just shortcode tags from the given content but remain content of shortcodes
/*-----------------------------------------------------------------------------------*/

function axiom_strip_shortcodes($content, $exclude_strip_shortcode_tags = null) {
    if(!$content) return $content;
    
    if(!$exclude_strip_shortcode_tags)
        $exclude_strip_shortcode_tags = axiom_exclude_strip_shortcode_tags();
    
    if( empty($exclude_strip_shortcode_tags) || !is_array($exclude_strip_shortcode_tags) )
        return preg_replace('/\[[^\]]*\]/', '', $content); //preg_replace("~(?:\[/?)[^/\]]+/?\]~s", '', $content);
    
    $exclude_codes = join('|', $exclude_strip_shortcode_tags);
    return preg_replace("~(?:\[/?)(?!(?:$exclude_codes))[^/\]]+/?\]~s", '', $content);
}

/*-----------------------------------------------------------------------------------*/
/*  The list of shortcode tags that should not be removed in axiom_strip_shortcodes
/*-----------------------------------------------------------------------------------*/

function axiom_exclude_strip_shortcode_tags(){
    return apply_filters("axiom_exclude_strip_shortcode_tags", array());
}

/*-----------------------------------------------------------------------------------*/
/*  Extract only raw text - remove all special charecters, html tags, js and css codes
/*-----------------------------------------------------------------------------------*/

function axiom_extract_text($content = null) {
    // decode encoded html tags
    $content = htmlspecialchars_decode($content);
    // remove script tag and inline js content
    $content = preg_replace('#<script(.*?)>(.*?)</script>#is', '', $content);
    // remove style tag and inline css content
    $content = preg_replace('#<style(.*?)>(.*?)</style>#is'  , '', $content);
    // remove iframe content
    $content = preg_replace('#<iframe(.*?)>(.*?)</iframe>#is', '', $content);
    // remove extra white spaces
    $content = preg_replace('/[\s]+/', ' ', $content );
    // strip html tags and escape special charecters
    $content = esc_attr(strip_tags($content));
    // remove double space 
    $content = preg_replace('/\s{3,}/',' ', $content );
    return $content;
}

/*-----------------------------------------------------------------------------------*/
/*  Prints markup for primary navigation menu
/*-----------------------------------------------------------------------------------*/

function axiom_nav_menu() {
    wp_nav_menu( apply_filters("axiom_nav_menu",
                                array(  'container'      => 'nav',
                                        'container_id'   => 'access',
                                        'menu_id'        => '',
                                        'menu_class'     => 'sf-menu',
                                        'theme_location' => 'primary' 
                                      )
                              )
                ); 
}

/*-----------------------------------------------------------------------------------*/
/*  List of theme admin pages
/*-----------------------------------------------------------------------------------*/

function axiom_theme_admin_pages(){
    return $theme_admin_pages = apply_filters( "axiom_theme_admin_pages", 
                                                array( "page", "post", "axi_product", "portfolio", 
                                                       "staff", "slider", "pricetable", "news" , "faq",
                                                       "toplevel_page_axiom", "service", "testimonial", 
                                                      )
                                              );
}

/*-----------------------------------------------------------------------------------*/
/*  Removes and return values from an array
/*-----------------------------------------------------------------------------------*/

function axiom_array_remove_val($array, $values = array()) {
    if( empty($values)    ) return  $values;
    if( is_string($values)) $values = array($values);
    if(!is_array ($values)) return  $values;
    
    return array_diff($array, $values);
}

/*-----------------------------------------------------------------------------------*/
/*  Excerpt configuration
/*-----------------------------------------------------------------------------------*/

if( ! function_exists("av3_excerpt_length") ){
    
    // Customizing default excerpt length
    function av3_excerpt_length( $length ) {
        return 30;
    }

}

if( ! function_exists("av3_continue_reading_link") ){
    
    // Returns a "Read more..." link for excerpts
    function av3_continue_reading_link() {
        return ' <a class="more" href="'. get_permalink() . '">' . __( 'Read more', 'default' ) . '</a>';
    }

}

if( ! function_exists("av3_auto_excerpt_more") ){
    
    // Appended "[...]" to automatically generated excerpts
    function av3_auto_excerpt_more( $more ) {
        if ( get_post_type() != 'portfolio' ) {
            return ' ...'; //av3_continue_reading_link().'...';
        }else{
            return '';
        }
    }

}

if( ! function_exists("av3_auto_excerpt_more") ){
        
    // Adds "Read more" link to custom post excerpts.
    function av3_custom_excerpt_more( $output ) {
        if ( has_excerpt() && get_post_type() != 'portfolio' ) {
            $output .= av3_continue_reading_link();
        }
        return $output;
    }  

}


//// Returns range list of numbers ///////////////////////////////////////////////////

if( ! function_exists("axiom_get_range") ){
    
    function axiom_get_range($start_num, $end_num, $default_values = array() ){
        return array_merge($default_values, range($start_num, $end_num));
    }

}

/*-----------------------------------------------------------------------------------*/
/*  Prints Widget Title
/*-----------------------------------------------------------------------------------*/

if( ! function_exists( 'get_widget_title') ){
    
    function get_widget_title( $title, $nav = '', $filters = NULL ){
        
        ob_start();
    ?>                             <header class="widget-title-bar">
    <?php if( ! empty( $title ) )  { ?>      <h3 class="widget-title"><?php echo $title; ?></h3>
    <?php } ?>
    <?php if( $nav == 'pagination' ){ ?>
                                       <div class="widget-nav pagination">
                                           <a href="" class="w_next"><?php _e( 'next', 'default' ); ?></a>
                                           <a href="" class="w_prev"><?php _e( 'previous', 'default' ); ?></a>
                                       </div><!-- widget-nav -->
    <?php } elseif ( $nav == 'filterable' && is_array( $filters ) ) { ?>
                                       <div class="widget-nav filterable">
                                           <a href="" class="active" data-filter="all" ><?php _e( 'All', 'default');?></a><span>/</span>
                                           <?php // loop throuth an array contains filters
                                           $len = count($filters);
                                           $counter = 0; // create a counter to add diffrent style for last filter
                                           foreach ( $filters as $key => $value ) {
                                               ++$counter;
                                           echo '<a href="" data-filter="'.$key.'" >'.$value.'</a>';
                                           echo ( $counter < $len ) ? '<span>/</span>' : '';
                                           } ?>
                                       </div><!-- widget-nav -->
    <?php } ?>                      </header><!-- widget-title-bar -->                                
    <?php
        return ob_get_clean();
    } 

}

/*-----------------------------------------------------------------------------------*/
/*  Is post type enabled or not
/*-----------------------------------------------------------------------------------*/

if( ! function_exists( 'axiom_is_post_type_active' ) ){
    
    function axiom_is_post_type_active($post_type){
        global $axiom_active_post_types;
        if(!isset($axiom_active_post_types)) return false;
        
        return key_exists($post_type, $axiom_active_post_types) && $axiom_active_post_types[$post_type];
    }

}

/*-----------------------------------------------------------------------------------*/
/*  Comments Template
/*-----------------------------------------------------------------------------------*/

if( ! function_exists("axiom_comment") ){
    
    function axiom_comment($comment, $args, $depth) {
       $GLOBALS['comment'] = $comment; ?>
       <li>
         <article <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
           <?php echo get_avatar($comment,'54', '' ); ?>
           <header class="comment-author vcard">
              <?php printf(__('<cite class="fn">%s</cite>'), get_comment_author_link()) ?>
              <time><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s at %2$s', 'default'), get_comment_date(),  get_comment_time()) ?></a></time>
              <?php if ($comment->comment_approved == '0') : ?>
                  <em><?php _e('Your comment is awaiting moderation.', 'default') ?></em>
                  <br />
               <?php endif; ?>
              <?php edit_comment_link(__('(Edit)', 'default'),'  ','') ?>
           </header>
           
           <div class="comment-body">
               <?php comment_text() ?>
           </div>
    
           <nav>
             <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
           </nav>
         </article>
        <!-- </li> is added by wordpress automatically -->
    <?php
    }

}

//// Get page layouts //////////////////////////////////////////////////////////////////////////////

// prints the page layout
function axiom_the_page_layout($id){
    echo axiom_get_page_layout($id);
}
    // outsputs the page layout [right-layout, left-layout, no-layout]
    if( ! function_exists("axiom_get_page_layout") ){
        
        function axiom_get_page_layout($id){
            return str_replace("sidebar", "layout", axiom_get_page_sidebar_pos($id));
        }
    
    }



// prints the status of page sidebar
function axiom_the_page_sidebar_pos($id){
    echo axiom_get_page_sidebar_pos($id);
}
    // outsputs the status of page sidebar [right-sidebar, left-sidebar, no-sidebar]
    if( ! function_exists("axiom_get_page_sidebar_pos") ){
    
        // returns page layout option
        function axiom_get_page_sidebar_pos($id){
            $layout = get_post_meta($id, "page_layout", true);
            $layout = ($layout != "right-sidebar") && ($layout != "left-sidebar") ? "no-sidebar": $layout;
            return apply_filters("axiom_get_page_sidebar_pos", $layout, $id);
        }
    
    }
    

//// specifies whether the page is full or has sidebar  /////////////////////////////////////////////

// specifies whether page is full or not (by layout name)
if( ! function_exists("axiom_is_full") ){
    
    function axiom_is_full( $layout ) {
        return ( ($layout == "right-sidebar") || ($layout == "left-sidebar") )?false:true;
    }
    
}

// specifies whether page is full or not (by page id)
if( ! function_exists("axiom_is_fullwidth") ){

    function axiom_is_fullwidth( $id ) {
         
        $layout = axiom_get_page_sidebar_pos($id);
        return axiom_is_full($layout);
    } 

}


//// Get archive page layout /////////////////////////////////////////////////////////////////////////

// prints archive layout option
function axiom_the_archive_sidebar_pos(){
    echo axiom_get_archive_sidebar_pos();
}

    if( ! function_exists("axiom_get_archive_sidebar_pos") ){
        
        // returns archive  layout option
        function axiom_get_archive_sidebar_pos(){
            $layout = "right-sidebar";
            
            $p_type = get_post_type();
            
            if( in_array($p_type, axiom_post_types_with_no_sidebar_on_archive()) )
                $layout = "no-sidebar";
                
            if($p_type == "news") {
                $cat_layout  = axiom_option('news_index_page_layout') == 'medium'?'land':'';
                $sidebar_pos = axiom_option('news_index_sidebar_position');
                $cat_sidebar = $sidebar_pos == ''?'right-sidebar':$sidebar_pos;
                $layout      = " list-news ".$cat_layout.' '.$cat_sidebar;
                unset($cat_layout, $sidebar_pos, $cat_sidebar);
            }
            
            return apply_filters("axiom_get_archive_sidebar_pos", $layout, $p_type);
        }
    
    }

//// Returns the list of post types that does not support sidebar on their archive pages //////////////

function axiom_post_types_with_no_sidebar_on_archive() {
    $post_types = array("portfolio", "axi_product", "service", "faq", "staff", "testimonial");
    return apply_filters("axiom_post_types_with_no_sidebar_on_archive", $post_types);
}

//// Get taxonomy page layout /////////////////////////////////////////////////////////////////////////

// prints taxonomy layout option
function axiom_the_taxonomy_sidebar_pos(){
    echo axiom_get_taxonomy_sidebar_pos();
}

    if( ! function_exists("axiom_get_taxonomy_sidebar_pos") ){
        
        // returns taxonomy  layout option
        function axiom_get_taxonomy_sidebar_pos(){
            $layout = "right-sidebar";
            $p_type = get_post_type();
            
            if( in_array($p_type, axiom_post_types_with_no_sidebar_on_taxonomy()) )
                $layout = "no-sidebar";
            
            if($p_type == "news") {
                $cat_layout  = axiom_option('news_category_page_layout') == 'medium'?'land':'';
                $sidebar_pos = axiom_option('news_category_sidebar_position');
                $cat_sidebar = $sidebar_pos == ''?'right-sidebar':$sidebar_pos;
                $layout      = " list-news ".$cat_layout.' '.$cat_sidebar;
                unset($cat_layout, $sidebar_pos, $cat_sidebar);
            }
            
            return apply_filters("axiom_get_taxonomy_sidebar_pos", $layout, $p_type);
        }
    
    }

//// Returns the list of post types that does not support sidebar on their taxonomy pages /////////////

function axiom_post_types_with_no_sidebar_on_taxonomy() {
    $post_types = array("portfolio", "axi_product", "service", "faq", "staff", "testimonial");
    return apply_filters("axiom_post_types_with_no_sidebar_on_taxonomy", $post_types);
}

//// get grid class names by percent size ////////////////////////////////////////////////////////////

function axiom_get_column_num_name($num){
    switch ($num) {
        case 5:
            return "five-column";
            break;
        case 4:
            return "four-column";
            break;
        case 3:
            return "three-column";
            break;
        case 2:
            return "two-column";
            break;
        case 1:
            return "one-column";
            break;
        default:
            return "three-column";
            break;
    }
}

function axiom_get_grid_column_name($size){
    switch ($size) {
        case 20:
            return "five-column";
            break;
        case 25:
            return "four-column";
            break;
        case 33:
            return "three-column";
            break;
        case 50:
            return "two-column";
            break;
        case 100:
            return "one-column";
            break;
        case "1/5":
            return "five-column";
            break;
        case "1/4":
            return "four-column";
            break;
        case "1/3":
            return "three-column";
            break;
        case "1/2":
            return "two-column";
            break;
        case "1/1":
            return "one-column";
            break;
        default:
            return "three-column";
            break;
    }
}

function axiom_get_grid_column_number($name){
    switch ($name) {
        case "five-column":
            return 20;
            break;
        case "four-column":
            return 25;
            break;
        case "three-column":
            return 33;
            break;
        case "two-column":
            return 50;
            break;
        case "one-column":
            return 100;
            break;
        default:
            return 33;
            break;
    }
}

function axiom_get_grid_name($size){
    switch ($size) {
        case 20:
            return "one_fifth";
            break;
        case 25:
            return "one_fourth";
            break;
        case 33:
            return "one_third";
            break;
        case 50:
            return "one_half";
            break;
        case 66:
            return "two_third";
            break;
        case 75:
            return "three_fourth";
            break;
        case 100:
            return "one_one";
            break;
        case "1/5":
            return "one_fifth";
            break;
        case "1/4":
            return "one_fourth";
            break;
        case "1/3":
            return "one_third";
            break;
        case "1/2":
            return "one_half";
            break;
        case "2/3":
            return "two_third";
            break;
        case "3/4":
            return "three_fourth";
            break;
        case "1/1":
            return "one_one";
            break;
        default:
            return "";
            break;
    }
}


function axiom_get_image_size_by_col_percent($size){
    global $axi_img_size;
    switch ($size) {
        case 20:
            return $axi_img_size["i5"];
            break;
        case 25:
            return $axi_img_size["i4"];
            break;
        case 33:
            return $axi_img_size["i3"];
            break;
        case 50:
            return $axi_img_size["i2"];
            break;
        case 100:
            return $axi_img_size["i1"];
            break;
        default:
            return $axi_img_size["i1"];
            break;
    }
}

/*-----------------------------------------------------------------------------------*/
/*  get featured image url (original images)
/*-----------------------------------------------------------------------------------*/

function av3_featured_img_url($featured_img_size) {
     $image_id  = get_post_thumbnail_id();
     $image_url = wp_get_attachment_image_src($image_id, $featured_img_size);
     $image_url = $image_url[0];
     
     return empty($image_url)?'':'<img alt="featured image" height="50px" src="' . $image_url . '" />';
}

// get featured image url by attachment id
function av3_get_attachment_url($attach_id, $featured_img_size = "medium") {
    if(is_numeric($attach_id) ){
        $image_url = wp_get_attachment_image_src($attach_id, $featured_img_size);
        return $image_url[0];
    }else{
        return $image_id;
    }
}

// get featured image url by post id
function av3_get_the_attachment_url($post_id, $img_size = "medium") {
    if(is_numeric($post_id) ){
        $image_url = wp_get_attachment_image_src(get_post_thumbnail_id( $post_id ), $img_size);
        return $image_url[0];
    }else{
        return $post_id;
    }
}

/*-----------------------------------------------------------------------------------*/
/*  Custom functions for resizing images 
/*-----------------------------------------------------------------------------------*/


// get resized image by image src ////////////////////////////////////////////////////

function axiom_the_resized_image( $img_url = "", $width = null , $height = null, $crop = null , $quality = 100 ) {
    echo axiom_get_the_resized_image( $img_url , $width , $height , $crop , $quality );
}

    if( ! function_exists("axiom_get_the_resized_image") ){
        
        function axiom_get_the_resized_image( $img_url = "", $width = null , $height = null, $crop = null , $quality = 100 ) {
            return '<img src="'.aq_resize( $img_url, $width, $height, $crop, $quality ).'" alt="" />';
        }
    
    }

        if( ! function_exists("axiom_get_the_resized_image_src") ){
            
            function axiom_get_the_resized_image_src( $img_url = "", $width = null , $height = null, $crop = null , $quality = 100 ) {
                $resized_img_url = aq_resize( $img_url, $width, $height, $crop, $quality );
                if(empty($resized_img_url)) $resized_img_url = $img_url;
                return apply_filters("axiom_get_the_resized_image_src", $resized_img_url, $img_url);
            }
        
        }


// get resized image featured by post id //////////////////////////////////////////////


// echo resized image tag
function axiom_the_post_thumbnail( $post_id = null, $width = null , $height = null, $crop = null , $quality = 100 ) {
    echo axiom_get_the_post_thumbnail( $post_id, $width , $height, $crop, $quality);
}

    if( ! function_exists("axiom_get_the_post_thumbnail") ){
        
        // return resized image tag
        function axiom_get_the_post_thumbnail( $post_id = null, $width = null , $height = null, $crop = null , $quality = 100 ) {
            $image_src = axiom_get_the_post_thumbnail_src( $post_id, $width , $height, $crop, $quality);
            return $image_src?'<img src="'.$image_src.'" alt="" />':"";
        }
    
    }

        if( ! function_exists("axiom_get_the_post_thumbnail_src") ){
        
            function axiom_get_the_post_thumbnail_src( $post_id = null, $width = null , $height = null, $crop = null , $quality = 100 ) {
                $post_id = ( null === $post_id ) ? get_the_ID() : $post_id;
                $post_thumbnail_id = get_post_thumbnail_id( $post_id );
                
                $img_url = wp_get_attachment_url( $post_thumbnail_id ,'full'); //get img URL
                
                $resized_img = $post_thumbnail_id?aq_resize( $img_url, $width, $height, $crop, $quality ):false;
                return apply_filters("axiom_get_the_post_thumbnail_src", $resized_img, $img_url, $width, $height, $crop, $quality);
            }
        
        }


// get resized image by attachment id ////////////////////////////////////////////////

// echo resized image tag
function axiom_the_resized_attachment( $attach_id = null, $width = null , $height = null, $crop = null , $quality = 100 ) {
    echo axiom_get_the_resized_attachment( $attach_id, $width , $height, $crop, $quality);
}

    if( ! function_exists("axiom_get_the_resized_attachment") ){
        
        // return resized image tag
        function axiom_get_the_resized_attachment( $attach_id = null, $width = null , $height = null, $crop = null , $quality = 100 ) {
            $image_src = axiom_get_the_resized_attachment_src( $attach_id, $width , $height, $crop, $quality);
            
            return $image_src ? '<img src="'.$image_src.'" alt="" />': "";
        }
    
    }

        if( ! function_exists("axiom_get_the_resized_attachment_src") ){
            
            function axiom_get_the_resized_attachment_src( $attach_id = null, $width = null , $height = null, $crop = null , $quality = 100 ) {
                if( null === $attach_id ) return;
                
                $img_url = wp_get_attachment_url( $attach_id ,'full'); //get img URL
                                           
                return !empty($img_url) ? aq_resize( $img_url, $width, $height, $crop, $quality ) : false;
            }
        
        }

        
//// returns the number of active columns in subfooter  ////////////////////////////////

if( ! function_exists("axiom_get_active_footer_columns") ){
    
    function axiom_get_active_footer_columns (){
        
        global $axiom_options;
        // default number of columns in footer
        $col_nums = 3;
        
        $layout   = axiom_get_footer_layout();
        $col_nums = substr($layout, 7, 1);
        
        return $col_nums;
    }

}

//// returns subfooter layout  ////////////////////////////////////////////////////////

if( ! function_exists("axiom_get_footer_layout") ){
    
    function axiom_get_footer_layout(){
        // default footer layout
        $layout = 'layout-3_33-33-33';
        
        // posibble layout values that user can set in option panel
        $footer_layouts = array( "layout-2_50-50" ,'layout-2_66-33' ,'layout-2_33-66' ,'layout-2_75-25' ,'layout-2_25-75' ,'layout-3_33-33-33','layout-3_50-25-25','layout-3_25-25-50','layout-4_25-25-25-25', 'layout-5_20-20-20-20-20');
        
        $footer_layouts = apply_filters("axiom_subfooter_layouts", $footer_layouts);
        
        // search to find out what value is checked
        foreach ($footer_layouts as $value) {
            if(axiom_option($value) == "checked" ){
                $layout = $value;
                break;
            }
        }
        
        return apply_filters("axiom_current_footer_layout", $layout, $footer_layouts);
    }

}

//// returns the width of nth column in subfooter  //////////////////////////////////

if( ! function_exists("axiom_get_nth_footer_column_width") ){
    
    function axiom_get_nth_footer_column_width($layout, $num){
        
        $size   = substr($layout, (6 + 3 * $num), 2);
        $output = axiom_get_grid_name($size);
        
        return $output;
    }

}

//// modify posts_per_page for current query  ///////////////////////////////////////

if( ! function_exists("axiom_update_query_var") ){
    
    function axiom_update_query_var($query_var = "posts_per_page", $per_page = 6){
        global $wp_query;
        $q_vars = $wp_query->query_vars;
        
        $paged = max(1, get_query_var('paged'), get_query_var('page'));
        $q_vars["paged"] = $paged;
        $q_vars[$query_var] = $per_page;
        
        query_posts($q_vars); 
    }
    
}

//// prints site socials   /////////////////////////////////////////////////////////

// print site socials /// 
function axiom_the_socials() {
    echo axiom_get_the_socials();
}

    if( ! function_exists("axiom_get_the_socials") ){
        
        // get site socials /// 
        function axiom_get_the_socials() {
            global $axiom_options;
            
            $output = "";
                      
            $output .= '<ul class="socials">';
                
                $socials = axiom_main_socials();
                
                $markup_template = '<li ><a class="%s" href="%s" target="_blank" ></a></li>';
                
                // get all socials links from site options and print if is set
                foreach ($socials as $value) {
                    if(isset($axiom_options[$value]) && !empty($axiom_options[$value]))
                        $output .= sprintf($markup_template, $value, $axiom_options[$value]);
                }
        
            $output .= '</ul><!-- end socials -->';
            
            return apply_filters("axiom_get_the_socials", $output, $socials, $markup_template);
        }
    
    }

    function axiom_main_socials() {
        return apply_filters("axiom_main_socials", array("facebook", "twitter", "gplus", "dribble", 
                                                         "youtube","vimeo", "vimeo2", "flicker", 
                                                         "digg", "stuble", "lastfm", "delicious", 
                                                         "skype", "linkedin", "tumblr", "pinterest",
                                                         "instagram" , "rss" )
                            );
    }


///// extract image from content ////////////////////////////////////////////////////

function axiom_get_first_image_from_content($content){
    $images = axiom_get_content_images($content);
    return ($images && count($images[0]))?$images[0][0]:"";
}

function axiom_get_first_image_src_from_content($content){
    $images = axiom_get_content_images($content);
    return ($images && count($images[0]) > 1)?$images[1][0]:"";
}

    if( ! function_exists("axiom_get_content_images") ){
        
        function axiom_get_content_images($content){
            preg_match_all( '|<img.*?src=[\'"](.*?)[\'"].*?>|i', $content, $matches );
            return isset( $matches ) && count($matches[0])? $matches : false;
        }
    
    }


//// Prints pagination nav   ///////////////////////////////////////////////////////

if( ! function_exists("axiom_the_paginate_nav") ){
    
    function axiom_the_paginate_nav(){
        global $wp_query;
        
        $format      = (get_option('permalink_structure'))?'page/%#%/':'&page=%#%';
        
        $page_link   = get_pagenum_link(1);
        
        // if the format is not structured, remove previous 'page' query string 
        if(!get_option('permalink_structure') ){
            
            list($urlpart, $qspart) = array_pad(explode('?', $page_link), 2, '');
            parse_str($qspart, $qsvars);
            unset($qsvars['#038;page']);
            
            $page_link =  $urlpart .'?'. http_build_query($qsvars);
            
        } else {
            // in some custome permalink "/" is missed at the end of url, add it here
            if(substr($page_link, -1) != '/') $page_link .= '/';
        }
        
        $total_pages = $wp_query->max_num_pages;
        
        if ($total_pages > 1){
          $current_page = max(1, get_query_var('paged'), get_query_var('page'));
          
          echo '<nav class="axi_paginate_nav">';
          echo paginate_links(array(
              'base' => $page_link . '%_%',
              'format' => $format,
              'current' => $current_page,
              'total' => $total_pages,
              'prev_text' => 'Prev',
              'next_text' => 'Next'
            ));
          echo '</nav>';
        }
    }

}

if( ! function_exists("axiom_the_search_paginate_nav") ){
    
    function axiom_the_search_paginate_nav(){
        global $wp_query;
        
        $format      = (get_option('permalink_structure'))?'page/%#%/':'&page=%#%';
        $page_link   = get_pagenum_link(1);
        $search      = "";
        
        list($urlpart, $qspart) = array_pad(explode('?', $page_link), 2, '');
        parse_str($qspart, $qsvars);
        $search = $qsvars['s'];
        
        unset($qsvars['#038;page']);
        unset($qsvars['#038;submit']);
        unset($qsvars['#038;s']);
        
        if(!get_option('permalink_structure'))
            $page_link =  $urlpart . '?' . http_build_query($qsvars) . '&submit=Search' . '%_%';
        else
            $page_link =  $urlpart . '%_%' . '?' . http_build_query($qsvars) . '&submit=Search';
        
        $total_pages = $wp_query->max_num_pages;
        
        if ($total_pages > 1){
          $current_page = max(1, get_query_var('paged'));
          
          echo '<nav class="axi_paginate_nav">';
          echo paginate_links(array(
              'base' => $page_link ,
              'format' => $format,
              'current' => $current_page,
              'total' => $total_pages,
              'prev_text' => 'Prev',
              'next_text' => 'Next'
            ));
          echo '</nav>';
        }
    }

}


//// Prints Page Titles  //////////////////////////////////////////////////////////

if( ! function_exists("axiom_the_main_title") ){
        
    function axiom_the_main_title($custom_title = NULL, $custom_subtitle = NULL){
        global $post;
        
        if( is_404() ) 
            return;
        
        $title    = "";
        $subtitle = "";
        
        
        if( isset( $custom_title ) || isset( $custom_subtitle ) ){
            
            $title    = $custom_title;
            $subtitle = $custom_subtitle; 
        
        }elseif( is_home() || is_search() ){
            
            if( is_home() ){
                $posts_page_id = get_option( 'page_for_posts' );
                $title = get_the_title( $posts_page_id );
            }
            if( is_search() ) $title = __( 'Results for: ', 'default' ) . get_search_query(); 
        
            /* If this is a category archive */ 
        }elseif ( is_archive() ) { 
                
            if(is_category() ){
                $title = __('Posts in category : ', 'default'). single_cat_title( '', false);
                $subtitle = category_description();
            /* If this is a tag archive */
            }elseif( is_tag() )
                $title = __('Posts tagged', 'default') . ': '. single_tag_title('', false);
            /* If this is a daily archive */ 
            elseif (is_day()) 
                $title = __("Daily Archives","default") .': '. get_the_date();
            /* If this is a monthly archive */ 
            elseif (is_month()) 
                $title = __("Monthly Archives","default") .': '. get_the_date('F Y');
            /* If this is a yearly archive */ 
            elseif (is_year())  
                $title = __("Yearly Archives","default") .': '. get_the_date('Y');
            /* If this is an author archive */ 
            elseif (is_author())
                $title = _x("All posts by : ", "Title of all posts by author","default") . get_the_author();
            /* If this is an author archive */  
            elseif (is_tax()) {
                $term  = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); 
                $title = $term->name;
            /* If this is a custom post type archive(index) page */
            } elseif( is_post_type_archive() ){
                $title = axiom_get_the_post_type_user_defined_name();
            }
        
        }elseif( is_singular() ) {
            
            $type     = isset( $post ) ? get_post_type(): '';
            $title    = isset( $post ) ? get_the_title(): ''; 
            
    
            if( is_single() && ( $type == 'testimonial' ) ) 
                $subtitle   = isset( $post ) ? get_post_meta( $post->ID, 'customer_job' , true) : '';
            else
                $subtitle   = isset( $post ) ? get_post_meta( $post->ID, 'page_subtitle', true) : '';
        }
        
        
        $show_title = isset( $post ) ? get_post_meta($post->ID, "show_title"   , true):"";
        $show_title = 'no' == $show_title ? false : true;
        
        // Is title section full or boxed?
        $widthClass = ( isset( $post ) && get_post_meta( $post->ID, 'axi_show_title_section_background', true ) == "yes" ) ? '' : 'container';
        
        // Filter title and subtitle
        $title      = apply_filters( 'axiom_the_main_title'   , $title    );
        $subtitle   = apply_filters( 'axiom_the_main_subtitle', $subtitle );
         
        if( ! empty( $title ) && $show_title ) { ?>
        <header id="page-title-section" >
            
            <div class="page-header <?php echo $widthClass. ' '; if( ! empty( $subtitle ) ) echo 'has-subtitle'; ?>">
                
                <div class="container fold" >
                    
                    <section>
                        <h1 class="page-title" itemprop="headline"><?php echo $title; ?></h1>
                        <?php if( ! empty( $subtitle ) ) { ?>
                        <h3 class="page-subtitle" ><?php echo $subtitle; ?></h3>
                        <?php } unset( $subtitle ); ?>
                    </section>
                    
                <?php // ------------- breadcrumb ---------------
                    axiom_the_breadcrumbs();
                ?>
                </div>
           
            </div><!-- end page header -->
            
        </header> <!-- end page header -->
        <?php } unset($title); 
    }

}

//// Prints Content Top margin  ////////////////////////////////////////////////////


function axiom_the_content_top_margin(){
    echo axiom_get_the_content_top_margin();
}

    if( ! function_exists("axiom_get_the_content_top_margin") ){
        
        function axiom_get_the_content_top_margin() {
        	global $post;
            if(!isset($post) || is_404() || is_tax() || is_post_type_archive())    return '';
            
            if(!($post->post_type == "page" || $post->post_type == "portfolio" || $post->post_type == "axi_product") ) return '';
            
            if(get_post_meta($post->ID, 'axi_show_content_top_margin', true) != "no")
                $html = '<div class="top_content"></div>';
            else
                $html = '';
            
            return apply_filters("axiom_get_the_content_top_margin", $html);
        }
    
    }


//// Prints Page Titles  ///////////////////////////////////////////////////////////

if( ! function_exists( 'axiom_the_header_slider' ) ){
        
    function axiom_the_header_slider($slider){
        
        if(!is_object($slider)) return;
        
        // get slider ID
        $slider_id = get_post_meta( $slider->ID, 'top_slider_id', true ) ;
        
        // get slider layout
        $slider_width   = get_post_meta( $slider->ID, 'top_slider_width'  , true ) ;
        $slider_divider = get_post_meta( $slider->ID, 'top_slider_divider', true ) ;
        $foldClass      = $slider_width == 'boxed' ? 'container' : '';
        
        $wrapper_start_tag = '<div id="site_topslider" class="'.$foldClass.'" >';
        $wrapper_end_tag   = '</div>';
        
        $space_bar_tag     = empty( $slider_divider ) || ( $slider_divider == 'pattern') ? '<div class="sep hbar"></div>' : '';
        
        $wrapper_start_tag = apply_filters( 'axiom_header_slider_wrapper_start_tag', $wrapper_start_tag, $slider);
        $wrapper_end_tag   = apply_filters( 'axiom_header_slider_wrapper_end_tag'  , $wrapper_end_tag  , $slider);
        
        
        do_action( 'axiom_the_header_slider', $slider, $wrapper_start_tag, $wrapper_end_tag, $space_bar_tag );
        
        
        if( ! isset( $slider_id ) || $slider_id == 'none' || empty( $slider_id ) ) return;
        
        // the slider is flex or nivo slider
        if( is_numeric( $slider_id ) ){
            // echo slider wrapper
            echo $wrapper_start_tag;
                
            $slider_options = get_post_meta( $slider_id, 'slider-data', true ); 
            
            if( $slider_options["type"] == 'flex' )
                echo do_shortcode('[the_flexslider id="'.$slider_id.'" ]');
            elseif($slider_options["type"] == 'nivo' )
                echo do_shortcode('[the_nivoslider id="'.$slider_id.'" ]');

            // action to display more slider types here
            do_action("axiom_the_header_builtin_slider", $slider_options["type"], $slider_id);
            
            echo $space_bar_tag;
            echo $wrapper_end_tag;
            
        // if the slider is layer slider   
        }elseif(substr($slider_id, 0, 3) == "ls_"){
            echo $wrapper_start_tag;
            
            $ls_id = substr($slider_id, 3);
            echo do_shortcode('[layerslider id="'.$ls_id.'" ]');
            
            echo $space_bar_tag;
            echo $wrapper_end_tag;
        
        // if the slider is cute slider  
        }elseif(substr($slider_id, 0, 3) == "cs_"){
            echo $wrapper_start_tag;
            
            $cs_id = substr($slider_id, 3);
            echo do_shortcode('[cuteslider id="'.$cs_id.'" ]');
            
            echo $space_bar_tag;
            echo $wrapper_end_tag;
         
        
        // if the slider is cute slider  
        }elseif(substr($slider_id, 0, 3) == "ms_"){
            echo $wrapper_start_tag;
            
            $ms_id = substr($slider_id, 3);
            echo do_shortcode('[masterslider id="'.$ms_id.'" ]');
            
            echo $space_bar_tag;
            echo $wrapper_end_tag;

        // the slider is revolution slider
        }elseif (class_exists('RevSlider') ){
            echo '<div id="site_topslider" >';
            
            putRevSlider($slider_id);
            
            echo $space_bar_tag;
            echo $wrapper_end_tag;
        }

    }

}


//// Check whether script has been registered  //////////////////////////////////////

function axi_is_script_registered($handle){
    return wp_script_is( $handle, "registered" );
}


//// print custom background styles  ////////////////////////////////////////////////

function axi_print_custom_background_style(){
    echo axi_get_custom_background_style();
}

    if( ! function_exists("axi_get_custom_background_style") ){
        
        function axi_get_custom_background_style(){
            global $post;
            if(!isset($post) || is_404()) return '';
            
            $p_id    =  $post->ID;
            if(!is_numeric($p_id))  return '';
            
            $output = "";
            
            if(get_post_meta($p_id, 'axi_show_custom_background', true) == "yes"){
                
                $color  = get_post_meta($p_id, 'axi_custom_background_color', true);
                $repeat = get_post_meta($p_id, 'axi_custom_background_repeat', true);
                $attach = get_post_meta($p_id, 'axi_custom_background_attachment', true);
                $position = get_post_meta($p_id, 'axi_custom_background_position', true);
                $image  = get_post_meta($p_id, 'axi_custom_background_image', true);
                $image  = axiom_get_the_absolute_image_url($image);
                
                $output .= "\tbody {";
                $output .= "\t";
                $output .= 'background:'.$color.' url('.$image.') '.$repeat. ' '.$attach.' '.$position. "; } \n";
                
                $output .= "\t#inner-body { max-width: 1050px; margin: 0 auto; } \n" ;
                $output .= "\t@media only screen and (min-width: 1024px) { #inner-body { max-width: 1050px; } } \n" ;
            }
            
            if(get_post_meta($p_id, 'axi_show_title_section_background', true) == "yes"){
                
                $color  = get_post_meta($p_id, 'axi_title_section_background_color', true);
                $repeat = get_post_meta($p_id, 'axi_title_section_background_repeat', true);
                $attach = get_post_meta($p_id, 'axi_title_section_background_attachment', true);
                $position = get_post_meta($p_id, 'axi_title_section_background_position', true);
                $image  = get_post_meta($p_id, 'axi_title_section_background_image', true);
                $image  = axiom_get_the_absolute_image_url($image);
                
                $output .= "\t#page-title-section .page-header {";
                $output .= "\t";
                $output .= 'background:'.$color.' url('.$image.') '.$repeat. ' '.$attach.' '.$position. "; } \n";
            }
            
            if(!empty($output) ){
                $style  = "<!-- Custom Background Style -->\n";
                $style .= "<style type=\"text/css\" >\n";
                $style .= stripslashes($output);
                $style .= "</style>\n";
                
                $output = $style;
            }
            
            return apply_filters("axi_get_custom_background_style", $output, $p_id);
        }
        
    }

//// check if the directory is writable  //////////////////////////////////////////////

function axiom_is_dir_writable($the_dir){
    if( ! function_exists('get_filesystem_method')) return false;
    
    return (get_filesystem_method(array(), $the_dir) == "direct");
}


//// inline css output fallback  //////////////////////////////////////////////////////

if( ! function_exists("axi_print_option_panel_styles_fallback") ){
    
    function axi_print_option_panel_styles_fallback(){
        
        $style = "";
        $css = get_option( 'axiom_'.THEME_ID.'_custom_CSS_options');
        
        if(!empty($css) ){
            $style  = "<!-- Custom Options Style -->\n";
            $style .= "<style type=\"text/css\" >\n";
            $style .= stripslashes($css);
            $style .= "</style>\n";
            
            echo $style;
        }
    }
    
}

//// Color Manipulation  /////////////////////////////////////////////////////////////

if( ! function_exists("ColorShader") ){
    
    function ColorShader($color, $dif=20){
     
      $color = str_replace('#', '', $color);
      if (strlen($color) != 6){ return '000000'; }
      $rgb = '';
      
      for ($x=0;$x<3;$x++){
        $c = hexdec(substr($color,(2*$x),2)) - $dif;
        $c = ($c < 0) ? 0 : dechex($c);
        $rgb .= (strlen($c) < 2) ? '0'.$c : $c;
      }
      
      return '#'.$rgb;
    }

}


/*-----------------------------------------------------------------------------------*/
/*  breadcrumb functions
/*-----------------------------------------------------------------------------------*/

if( ! function_exists( 'axiom_the_breadcrumbs' ) ){

    function axiom_the_breadcrumbs() {
        
        // Use yoast breadcrumb if it's available
        if ( function_exists('yoast_breadcrumb') ) {
           yoast_breadcrumb('<p id="axi_breadcrumbs">','</p>');
           return;
        }
        
        global $post, $axiom_options;
         
        if( is_home() ||  is_front_page() || is_404() || is_search() || !isset($post) ){ return; }
        
        $this_temp_name = get_post_meta( $post->ID, '_wp_page_template', TRUE );
        $this_page_type = $post->post_type;
        
        
        $crumbs  =  '';
        $crumbs .=  '<p id="axi_breadcrumbs"><span><a href="'. get_option('home') .'">' . _x( 'Home', 'Home in breadcrumb' ,'default' ) . '</a></span>';
        
        //if it is page
        if( is_page() ) {
            
            $branch = array(' / <span> '.get_the_title($post->ID). '</span>');
            
            // loops thtough branch if has parent
            $p_post = $post;
            
            while ($p_post->post_parent) {
                $branch[] = ' / <span><a href="'.get_permalink( $p_post->post_parent ).'">'.get_the_title($p_post->post_parent).'</a></span>';
                $p_post   = get_post($p_post->post_parent);
            }
            
            $branch  = array_reverse($branch);
            $crumbs .= implode("", $branch);
            $crumbs .= '</p>'."\n";
        }
        
        //if it's a single news/blog post --------------------------
        
        if( is_single() ) {
            
            $count_limit = 1;
            
            if( $this_page_type == "news" ) {
                $tax      = 'news-category';
                $crumbs  .= axiom_get_the_single_breadcrumb_branch( $tax );

            } elseif( $this_page_type == "post" ) {
                $tax      = 'category';
                $crumbs  .= axiom_get_the_single_breadcrumb_branch( $tax );

            } elseif ( $this_page_type == "portfolio" ) {
                
                $nav_type = ! isset( $axiom_options["portfolio_single_nav_type"] ) ? 'breadcrumb' : $axiom_options["portfolio_single_nav_type"];
                
                if( $nav_type == "breadcrumb" ){
                    $tax      = 'project-type';
                    $crumbs  .= axiom_get_the_single_breadcrumb_branch($tax);
                
                } elseif( $nav_type == "next_prev" ) {

                    $list_page = sprintf( '<a href="%s">%s</a>', get_post_type_archive_link( get_post_type() ), __( 'show all', 'default' ) );
                    echo axiom_get_next_prev_post_link( '<p id="axi_breadcrumbs"><span>', '</span>', '</span> / <span>', $list_page );
                    $crumbs  =    '';
                    
                } else { $crumbs = ""; }

            } elseif ( $this_page_type == 'axi_product' ) {
                
                $nav_type = ! isset( $axiom_options["product_single_nav_type"] ) ? "breadcrumb" : $axiom_options["product_single_nav_type"];
                
                if( $nav_type == "breadcrumb" ){
                    $tax      = 'product-category';
                    $crumbs  .= axiom_get_the_single_breadcrumb_branch($tax);
                    
                } elseif( $nav_type == "next_prev" ) {

                    $list_page = sprintf( '<a href="%s">%s</a>', get_post_type_archive_link( get_post_type() ), __( 'show all', 'default' ) );
                    echo axiom_get_next_prev_post_link( '<p id="axi_breadcrumbs"><span>', '</span>', '</span> / <span>', $list_page );
                    $crumbs  =    '';
                    
                } else { $crumbs = ""; }

            } elseif ( $this_page_type == "staff" ) {
                $tax      = 'departman';
                $crumbs  .= axiom_get_the_single_breadcrumb_branch($tax);

            } elseif ( $this_page_type == "testimonial" ) {
                $tax      = 'testimonial-category';
                $crumbs  .= axiom_get_the_single_breadcrumb_branch($tax);

            } else {
                $crumbs .= ' / <span> '.get_the_title($post->ID). '</span>';
                $crumbs .=    '</p>'."\n";
            }
            
        }
        
        elseif( is_tax() ) {
            
            $tax    = get_query_var('taxonomy');
            $term   = get_term_by('slug', get_query_var( 'term' ), $tax );
            $branch = array(' / <span> '.$term->name. '</span>');
            
            // loops thtough branch if term has parent
            $parent_id = $term->parent;
            
            while ($parent_id) {
                $parent    = get_term_by( 'id', $parent_id, $tax);
                $branch[]  = ' / <span><a href="'.get_term_link($parent->slug, $tax ).'">'.$parent->name.'</a></span>';
                $parent_id = $parent->parent;
            }
            
            $branch[]= ' / <span><a href="'.get_post_type_archive_link( get_post_type() ).'">'.axiom_get_the_post_type_user_defined_name().'</a></span>';
            
            $branch  = array_reverse($branch);
            $crumbs .= implode("", $branch);
            $crumbs .= '</p>'."\n";
        }
        
        //if it's custom post type archive (index) page
        elseif( is_post_type_archive() ) {
            $crumbs       .= ' / <span> '.axiom_get_the_post_type_user_defined_name(). '</span>';
            $crumbs       .= '</p>'."\n";
        }
        
        // if it's blog category page 
        elseif( is_category() || is_tag() ) {
            $crumbs .= ' / <span> '.single_term_title( '', false ). '</span>';
            $crumbs .=    '</p>'."\n";
        }

        //if it's the news/blog home page or any type of archive
        elseif( is_archive() ) {
            $crumbs .= ' / <span> '.post_type_archive_title( '', false ). '</span>';
            $crumbs .=    '</p>'."\n";
        }
        
        echo $crumbs;
    }

}


if( ! function_exists( 'axiom_get_next_prev_post_link' ) ){

    function axiom_get_next_prev_post_link( $start_tag = '<p id="axi_breadcrumbs"><span>', $end_tag = '</span></p>', $sep = '</span> / <span>', $middle_tag = '' ){

        $output  = $start_tag;
        $output .= get_previous_post_link( '%link', _x( 'previous', 'navigate to previous page', 'default' ) );
        $output .= $sep;
        $output .= ! empty( $middle_tag ) ? $middle_tag . $sep : '';
        $output .= get_next_post_link( '%link', _x( 'next', 'navigate to next page', 'default' ) );
        $output .= $end_tag;

        echo $output;
    }

}


if( ! function_exists( 'axiom_get_the_single_breadcrumb_branch' ) ){
    
    // returns all breadcrumb branches for single page
    function axiom_get_the_single_breadcrumb_branch( $tax ){
        global $post;
        if( ! isset($post) ) return '';
        
        $cat_terms = wp_get_post_terms( $post->ID, $tax ); 
                
        if( is_array( $cat_terms ) && isset( $cat_terms[0] ) ){
            
            $term   = $cat_terms[0];
            $branch = array(' / <span><a href="'.get_term_link($term->slug, $tax ).'">'.$term->name.'</a></span>');
            
            // loops thtough branch if term has parent
            $parent_id = $term->parent;
            
            while ($parent_id) {
                $parent    = get_term_by( 'id', $parent_id, $tax);
                $branch[]  = ' / <span><a href="'.get_term_link($parent->slug, $tax ).'">'.$parent->name.'</a></span>';
                $parent_id = $parent->parent;
            }
            
            if($post->post_type != "post" )
                $branch[]= ' / <span><a href="'.get_post_type_archive_link( $post->post_type ).'">'.axiom_get_the_post_type_user_defined_name().'</a></span>';
            
            $branch  = array_reverse($branch);
            $crumbs  = implode("", $branch);
            $crumbs .= ' / <span> '.get_the_title( $post->ID ). '</span>';
            $crumbs .= '</p>'."\n";
            
            return $crumbs;
        }
        
        return '';
    }

}

/*-----------------------------------------------------------------------------------*/
/*  Returns post type menu name
/*-----------------------------------------------------------------------------------*/

if( ! function_exists( 'axiom_get_the_post_type_name' ) ){
    
    // returns post type menu name
    function axiom_get_the_post_type_name( $post_type = '' ){
        $post_type     = empty( $post_type ) ? get_post_type() : $post_type;
        $post_type_obj = get_post_type_object( $post_type );

        return apply_filters( 'axiom_get_the_post_type_name', $post_type_obj->labels->menu_name, $post_type );
    }

}

/*-----------------------------------------------------------------------------------*/
/*  Get data about current main/parent theme
/*-----------------------------------------------------------------------------------*/

function auxin_get_main_theme(){
    $theme = wp_get_theme();
    // always use parent theme data - averta
    if( is_child_theme() )
        $theme = wp_get_theme( $theme->template );
    return $theme;
}

/*-----------------------------------------------------------------------------------*/
/*  Returns alternative for post type names if user defined custom name in option panel
/*-----------------------------------------------------------------------------------*/

if( ! function_exists( 'axiom_get_the_post_type_user_defined_name' ) ){

    function axiom_get_the_post_type_user_defined_name( $post_type = '' ){
        $post_type      = empty( $post_type ) ? get_post_type() : $post_type;
        $post_type_obj  = get_post_type_object( $post_type );

        $post_type_name = $post_type_obj->labels->menu_name;
        $alter_name     = axiom_option( THEME_ID.'_'.$post_type.'_custom_name' );
        
        return empty( $alter_name ) ? $post_type_name : $alter_name;
    }

}

/*-----------------------------------------------------------------------------------*/
/*  A function to print array or objects nicely!
/*-----------------------------------------------------------------------------------*/

if(  ! function_exists('pretty_print') ){

    function pretty_print($data){
        echo "<pre>";
        print_r($data);
        echo "</pre>";
    }

}

