<?php 
/**
 * Class to add permalink setting for averta themes
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */
 
/**
 * 
 */
class AxiomScreenHlep {
	
    
	function __construct() {
	    
        add_action( 'contextual_help', array($this, 'display_technical_info') , 10, 3 );
        
        // if debaug mode is enabled display screen information in help tabs
        if( !(defined("WP_DEBUG") && !WP_DEBUG ) ){
	       add_action( 'contextual_help', array($this, 'display_screen_info') , 10, 3 );
        }
        
        // if display support info is not disabled, show them
        if ( AXIOM_SUPPORT  && !AXIOM_NO_BRAND )
            add_action( 'contextual_help', array($this, 'display_support_info'), 10, 3 );
	}
    
    
    
    
    public function display_screen_info( $contextual_help, $screen_id, $screen ) {
        
        if ( ! method_exists( $screen, 'add_help_tab' ) ) return $contextual_help;
        
        global $hook_suffix;
        
        // List screen properties
        $variables = '<ul style="width:50%;float:left;"> <strong>Screen variables </strong>'
            . sprintf( '<li> Screen id : %s</li>', $screen_id )
            . sprintf( '<li> Screen base : %s</li>', $screen->base )
            . sprintf( '<li> Parent base : %s</li>', $screen->parent_base )
            . sprintf( '<li> Parent file : %s</li>', $screen->parent_file )
            . sprintf( '<li> Hook suffix : %s</li>', $hook_suffix )
            . '</ul>';
    
        // Append global $hook_suffix to the hook stems
        $hooks = array(
            "load-$hook_suffix",
            "admin_print_styles-$hook_suffix",
            "admin_print_scripts-$hook_suffix",
            "admin_head-$hook_suffix",
            "admin_footer-$hook_suffix"
        );
        
        // If add_meta_boxes or add_meta_boxes_{screen_id} is used, list these too
        if ( did_action( 'add_meta_boxes_' . $screen_id ) )
            $hooks[] = 'add_meta_boxes_' . $screen_id;
    
        if ( did_action( 'add_meta_boxes' ) ) $hooks[] = 'add_meta_boxes';
        
        $hooks = '<ul style="width:50%;float:left;"> <strong>Hooks </strong> <li>' . implode( '</li><li>', $hooks ) . '</li></ul>';
        
        // Combine $variables list with $hooks list.
        $help_content = $variables . $hooks;
        
        // Add help panel
        $screen->add_help_tab( 
            array('id' => 'axiom-screen-help',
                'title'=> 'Screen Information',
                'content' => $help_content,
            )
        );
        return $contextual_help;
    }
    
    
    
    
    
    public function display_technical_info( $contextual_help, $screen_id, $screen ) {
        
        if ( ! method_exists( $screen, 'add_help_tab' ) ) return $contextual_help;
        
        
        // List screen properties
        $help_content  = '<ul style="width:50%;float:left;"> <strong>Web server</strong>';
        $help_content .= '<li>php version : ' . phpversion(). '</li>';
        $help_content .= $this->get_ini_val('max_execution_time'     , 'max_execution_time');
        $help_content .= $this->get_ini_val('max_file_uploads'       , 'max_file_uploads');
        $help_content .= $this->get_ini_val('max_input_nesting_level', 'max_input_nesting_level');
        $help_content .= $this->get_ini_val('max_input_time'         , 'max_input_time');
        $help_content .= $this->get_ini_val('max_input_vars'         , 'max_input_vars');
        $help_content .= $this->get_ini_val('memory_limit'           , 'memory_limit');
        $help_content .= $this->get_ini_val('post_max_size'          , 'post_max_size');
        $help_content .= $this->get_ini_val('upload_max_filesize'    , 'upload_max_filesize');
        $help_content .= $this->get_ini_val('output_buffering'       , 'output_buffering');
        $help_content .= $this->get_ini_val('short_open_tag'         , 'short_open_tag');
        
        if( function_exists('get_filesystem_method') )
            $help_content .= sprintf( '<li> FileSystem : %s</li>', get_filesystem_method(array(), THEME_DIR) );
        
        $help_content .= '</ul>';
        
        
        $help_content .= '<ul style="width:50%;float:left;"> <strong>Web server</strong>';
        
        if(function_exists("get_loaded_extensions"))
        $help_content .= sprintf( '<li> Extentions : %s</li>', implode(' ,', get_loaded_extensions())); 
        
        if(extension_loaded('suhosin'))
        $help_content .= '<li> Suhosin : Available</li>'; 
        
        if(!function_exists('mb_strwidth'))
        $help_content .= '<li> mb_* package : Unavailable. <a href="http://www.2by2host.com/articles/php-errors-faq/disabled_mb_strwidth/">How to enable?</a></li>'; 
        
        $help_content .= $this->get_ini_val('disable_functions'      , 'disable_functions');
        $help_content .= '</ul>';
        
        
        // Add help panel
        $screen->add_help_tab( 
            array('id' => 'axiom-technical-info',
                'title'=> 'Technical Information',
                'content' => $help_content,
            )
        );
        return $contextual_help;
    }
    
    
    
    private function get_ini_val($label , $var){
        $value = ini_get($var);
        return $value === false?"":sprintf( '<li> %s : %s</li>', $label, $value );
    }
    
    
    
    public function display_support_info( $contextual_help, $screen_id, $screen ) {
        
        if ( !method_exists( $screen, 'add_help_tab' ) )        return $contextual_help;
        
        ob_start();
        
        ?>
        <br />
        <strong>DO YOU NEED SUPPORT? PLEASE Do THE FOLLOWING :</strong>
        <ul>
        <li>1 - Please read item's <a href="http://support.averta.net/envato/documentations/">documentation </a> </li>
        <li>2 - Take a look in our <a href="http://support.averta.net/envato/faq/">FAQ</a> page</li>
        <li>3 - Take a look in our <a href="http://support.averta.net/envato/knowledgebase/">Knowledge base</a></li>
        <li>4 - Take a look in <a href="http://support.averta.net/envato/videos/">Video Tutorials</a> page</li>
        <li>5 - Still have questions(s)? <a href="http://support.averta.net/envato/wp-login.php?action=register" rel="nofollow">Create an Account</a> in <a href="http://support.averta.net/envato/support/" rel="nofollow">Support Forums</a> (<a href="http://i44.tinypic.com/311rr4h.jpg" rel="nofollow">Find your “Item Purchase Code”</a>)</li>
        <li>6 - Use search field at the top of support forum for similar topics</li>
        <li>7 - If you still didn't find your answers please post your question(s) in the item’s <a href="http://support.averta.net/envato/support/">support forum</a>
        Our support staff are there to help you as soon as possible.</li>
        </ul>
        <br />
        
        
        <strong>WHY SUPPORT FORUM?</strong><br />
        You can upload images and insert code with code-highlighting.<br/>
        It is organized and searchable (that makes support easier and faster)<br/><br />
        
        <strong>Supporting Our Items INCLUDES</strong>:
        <ul>
          <li>Responding to questions or problems regarding our item and its features</li>
          <li>Fixing bugs and reported issues</li>
          <li>Providing updates to ensure compatibility with new software versions</li>
        </ul>
        <br/>
        
        <strong>Item Support does NOT include</strong>:
        <ul>
          <li>Customization and installation services</li>
          <li>Support for third party software and plug-ins</li>
        </ul>
        <br/>
        
        <strong>IMPORTANT :</strong>
        <p>We <strong>CAN NOT</strong> provide support via email.
        Please ask your support related questions only in our support forum.</p>
        <br />

        <?php
        
        // Add help panel
        $screen->add_help_tab( 
            array('id'      => 'axiom-support-tab',
                  'title'   => __('Theme Support', 'default'),
                  'content' => ob_get_clean(),
            )
        );
        return $contextual_help;
    }
    
}

$axi_screen = new AxiomScreenHlep();

?>