<?php
/**
 * Class to add permalink setting for averta themes
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */
 
 /**
  * 
  */
 class AxiomPermalink {
     
     public $prefix             = "axiom";
     public $theme_name         = "averta";
     public $option_group       = "permalink"; 
     public $default_post_types = array("portfolio", "axi_product", "news", 
                                        "service"  , "faq", "staff", "testimonial", 
                                        "slider"   , "pricetable");
     
     
     function __construct() {
         if(defined("THEME_ID"))   $this->prefix     = THEME_ID;
         if(defined("THEME_NAME")) $this->theme_name = THEME_NAME;
     }
     
     
     
     public function setup(){
         // setup hooks
         add_action("admin_init", array($this, "extend_permalinks_page") );
         add_action("admin_init", array($this, "flush_rewrite_rules_queue") );
         add_action("load-options-permalink.php" , array($this, "store_posted_custom_permalink_slugs") );
     }

     
     
     
     public function store_posted_custom_permalink_slugs(){
        
        foreach ($this->default_post_types as $post_type) {
            
            if(isset($_POST['submit']) and isset($_POST['_wp_http_referer'])){
                if( strpos($_POST['_wp_http_referer'],'options-permalink.php') !== FALSE ) {
                    
                    $single_option_name  = $this->prefix.'_'.$post_type.'_structure';
                    
                    // get post type structure
                    $structure = trim(esc_attr($_POST[$single_option_name]));
                    
                    // default permalink structure
                    if( !$structure ) $structure = $post_type;
                    
                    $structure = trim($structure, '/');
                    
                    update_option($single_option_name, $structure );
                    
                    
                    // if post type has archive enabled
                    if(get_post_type_object($post_type)->has_archive){
                    
                        $archive_option_name = $this->prefix.'_'.$post_type.'_archive_structure';
                        
                        // get post type structure
                        $structure = trim(esc_attr($_POST[$archive_option_name]));
                        
                        // default permalink structure
                        if( !$structure ) $structure = $post_type."/all";
                        
                        $structure = trim($structure, '/');
                        
                        update_option($archive_option_name, $structure );
                    }
                }
            }
            
        }
    }

    
    
    
    public function pending_rewrite_rules(){
        update_option($this->prefix."_pending_rewrite_rules", 1);
    }
    
    
    
    
    public function flush_rewrite_rules_queue () {
        
        if(get_option( $this->prefix."_pending_rewrite_rules" )){
            flush_rewrite_rules();
            update_option( $this->prefix."_pending_rewrite_rules", 0 );
        }
    }
    
    
    
    
    public function extend_permalinks_page(){
        
        $this->set_current_post_types();
        $this->add_section();
        $this->set_default_permalink_slugs();
        
        foreach ($this->default_post_types as $post_type) {
            $this->add_update_hooks   ($post_type);
            $this->add_posttype_fields($post_type);
        }
    }
    
    
    
    private function set_current_post_types(){
        global $axiom_active_post_types;
        
        if(isset($axiom_active_post_types)) {
            $this->default_post_types = array();
            // loop through all post types and collect active ones
            foreach ($axiom_active_post_types as $key => $value)
                 if ($axiom_active_post_types[$key]) $this->default_post_types[] = $key;
        }
    }
    
    
    
    private function add_section(){
        
        add_settings_section(
            'axiom_posttypes_permalink_setting_section',
            sprintf('<br />'.__("%s Permalink Setting",'default'), __($this->theme_name, "default")),
            array($this, 'posttypes_permalink_section_callback_function'),
            $this->option_group
        );
    }
    
    
    
    
    private function set_default_permalink_slugs(){
        
        $is_updated = get_option($this->prefix.'_permalink_options_initialized');
        
        if($is_updated) return;
        
        
        foreach ($this->default_post_types as $post_type) {
            
            $single_option_name  = $this->prefix.'_'.$post_type.'_structure';
                    
            // get post type structure
            $structure = get_option($single_option_name);
            
            // default permalink structure
            if( !$structure ) { $structure = $post_type == "axi_product"?"product":$post_type; }  
            
            $structure = trim($structure, '/');
            update_option($single_option_name, $structure );
            
            
            // if post type has archive enabled
            if(get_post_type_object($post_type)->has_archive){
                
                $archive_option_name = $this->prefix.'_'.$post_type.'_archive_structure';
                
                // get post type structure
                $structure = get_option($archive_option_name);
                
                // default permalink structure
                if( !$structure ) { $structure = $post_type == "axi_product"?"product/all":$post_type."/all"; }  
                
                $structure = trim($structure, '/');
                update_option($archive_option_name, $structure );
            }
        }
        
        update_option($this->prefix.'_permalink_options_initialized', 1);
    }
    
    
    
    
    public function add_update_hooks($post_type){
        add_action('update_option_'.$this->prefix.'_'.$post_type.'_structure'         , array( $this, 'pending_rewrite_rules'), 10, 2);
        
        if(get_post_type_object($post_type)->has_archive)
            add_action('update_option_'.$this->prefix.'_'.$post_type.'_archive_structure' , array( $this, 'pending_rewrite_rules'), 10, 2);
    }
    
    
    
    
    private function add_posttype_fields($post_type){
        
        add_settings_field('axiom_'.$post_type.'_structure',
            sprintf(__('Setting for <strong>%s single</strong> page', "default"), $post_type),
            array($this, 'posttypes_permalink_fields_callback_function'),
            $this->option_group,
            'axiom_posttypes_permalink_setting_section',
            array("post_type" => $post_type, "is_archive" => "no")
        );
        
        register_setting($this->option_group,'axiom_'.$post_type.'_structure');
        
        if(get_post_type_object($post_type)->has_archive){
        
            add_settings_field('axiom_'.$post_type.'_archive_structure',
                sprintf(__('Setting for <strong>%s archive</strong> page ', "default"), $post_type),
                array($this, 'posttypes_permalink_fields_callback_function'),
                $this->option_group,
                'axiom_posttypes_permalink_setting_section',
                array("post_type" => $post_type, "is_archive" => "yes")
            );
            
            register_setting($this->option_group,'axiom_'.$post_type.'_archive_structure');
        }
    }
    
    
    
    public function posttypes_permalink_section_callback_function(){
        _e('These settings control the permalinks used for theme\'s post types. These settings only apply when <strong>not using "default" permalinks above</strong>.', 'default');
        echo "<br /><br />";
    }
    
    
    
    
    public function posttypes_permalink_fields_callback_function($options) {
        
        $post_type_obj = get_post_type_object($options["post_type"]);
        
        $suffix        = $options["is_archive"] == "yes"?"_archive_structure":"_structure";
        $output_suffix = $options["is_archive"] == "yes"?"":'<code>/'.__("sample-post", "default").'/</code>';
        
        $option_id     = $this->prefix.'_'.$options["post_type"].$suffix;
        $val = get_option($option_id);
        
        printf('<code>%1$s/</code><input id="%2$s" name="%2$s" type="text" value="%3$s" />%4$s', home_url(), $option_id, $val, $output_suffix);
    }
    
}

?>
