<?php
    // Includes all defined options
    include AXI_INC.'options/axiom-options.php';
    
    // loop through all options and get typography elements
    // then import css files for existing google early fonts
    foreach ($options as $option) {
        if($option['type'] == 'typography'){
            // get stored font name
            $eaa_face = isset($axiom_options[$option['id'].'[face]'])?$axiom_options[$option['id'].'[face]']:"";
            
            // srore all google fonts in a list
            if(axi_is_earlyaccess_googlefont($eaa_face)){
                $eaa_face = substr($eaa_face, 4);
                $eaa_face = str_replace(" ", "", $eaa_face);
                $eaa_face = strtolower($eaa_face);
                echo "\n@import url(http://fonts.googleapis.com/earlyaccess/".$eaa_face.".css);\n\n";
            }
        }
    }
?>

body {
    font-family: <?php axi_the_fontface('content_typography[face]'); ?>,arial,sans-serif;
    color: <?php echo $styles['content_typography[color]']; ?>;
}
input, select, textarea { font-family: <?php axi_the_fontface('content_typography[face]'); ?>,arial,sans-serif; }

.open-sans, h1, h2, h3, h4, h5, h6, header#siteheader #logo h2, header#siteheader #logo h3, 
.flexslider.side-circle-slider .slides > li p, 
.stunning p, .widget-testimonial .testimonial-author, .widget_testimonial .testimonial-author ,
.widget-blog .entry-title a, .list-post .entry-title a, .widget_recent_blog .entry-title a ,
.widget-staff figcaption .item-title a {
    font-family: <?php axi_the_fontface('main_title_typography[face]'); ?>,arial,sans-serif;
    color: <?php echo $styles['main_title_typography[color]']; ?>;
}

.merri, 
.callout .widget-title, 
.callout p, 
.stunning .widget-title, 
.stunning p,
.callout a.featured_btn {
    font-family: <?php axi_the_fontface('stunning_typography[face]'); ?>,georgia,serif;
}

.stunning .widget-title, 
.stunning p {
    color: <?php echo $styles['stunning_typography[color]']; ?>;
}


.page-title {
    font-family: <?php axi_the_fontface('page_title_typography[face]'); ?>,georgia,serif;
    color: <?php echo $styles['page_title_typography[color]']; ?>;
}

header#siteheader nav li {
    font-family: <?php axi_the_fontface('header_menu_typography[face]'); ?>,arial,sans-serif;
}

