<?php
/**
 * Pointers (Tooltips) to introduce new theme feature or any notify in admin area
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */



/*-----------------------------------------------------------------------------------*/
/*  Display Admin Pointers
/*-----------------------------------------------------------------------------------*/

function axiom_init_custom_axiom_classes(){
    
    // init permalink manager page ///////////////////////////////////////////////////
    $axi_permalink = new AxiomPermalink();
    $axi_permalink->setup(); 
    
    
    
    
    // admin admin pointers /////////////////////////////////////////////////////////
    $axi_pointers = new AxiomPointers();
    $axi_pointers->add( array(
                            'id'         => 'lotus_22_disable_seo',     // Unique id for pointer
                            'hook_suffix'=> 'toplevel_page_axiom',   // Screen hook suffix to show pointer on [empty means display every where on admin] (dashboard : index.php)
                            'target'     => '#disable_theme_seo', // Css selector to hang the pointer to that element
                            'version'    => '2.2',         // The theme version to display tooltip on
                            'title'      => 'New option to disable built-in SEO',  // Tooltip title
                            'content'    => 'If you want to use SEO plugins like "WordPress SEO by Yoast" or "All in One SEO Pack" you can disable built-in SEO for maximum compatibility by checking this option. This theme is fully compatible and optimized for SEO plugins.', // Tooltip description
                            'position'   =>  array( 
                                                 'edge'  => 'top',   //top, bottom, left, right
                                                 'align' => 'middle' //top, bottom, left, right, middle
                                                )
                             )
                       );
                       
    $axi_pointers->add( array(
                            'id'         => 'lotus_22_required_plugins',     // Unique id for pointer
                            'hook_suffix'=> 'themes.php',   // Screen hook suffix to show pointer on [empty means display every where on admin] (dashboard : index.php)
                            'target'     => '.theme-options ul li:last', // Css selector to hang the pointer to that element
                            'version'    => '2.2',         // The theme version to display tooltip on
                            'title'      => 'Install Required Plugins',  // Tooltip title
                            'content'    => 'This theme requires some plugins, please check the page and install "Theme Required Plugins".', // Tooltip description
                            'position'   =>  array( 
                                                 'edge'  => 'top',   //top, bottom, left, right
                                                 'align' => 'middle' //top, bottom, left, right, middle
                                                )
                             )
                       );           
                       
    $axi_pointers->add( array(
                            'id'         => 'lotus_22_help_support',     // Unique id for pointer
                            'hook_suffix'=> 'index.php',   // Screen hook suffix to show pointer on [empty means display every where on admin] (dashboard : index.php)
                            'target'     => '#contextual-help-link', // Css selector to hang the pointer to that element
                            'version'    => '2.2',         // The theme version to display tooltip on
                            'title'      => 'Do you have any questions about theme?',  // Tooltip title
                            'content'    => 'Please open contextual help panel (click the help button at top right side of admin panel), in "Theme support" tab follow our support steps.', // Tooltip description
                            'position'   =>  array( 
                                                 'edge'  => 'top',   //top, bottom, left, right
                                                 'align' => 'middle' //top, bottom, left, right, middle
                                                )
                             )
                       ); 
                       
    $axi_pointers->add( array(
                            'id'         => 'lotus_22_slug_manager',     // Unique id for pointer
                            'hook_suffix'=> '',   // Screen hook suffix to show pointer on [empty means display every where on admin] (dashboard : index.php)
                            'target'     => '#menu-settings', // Css selector to hang the pointer to that element
                            'version'    => '2.2',         // The theme version to display tooltip on
                            'title'      => 'New Feature : Theme Permalink Manager',  // Tooltip title
                            'content'    => 'With this feature, now you can change all post type slugs directly in setting > permalink page.', // Tooltip description
                            'position'   =>  array( 
                                                 'edge'  => 'left',   //top, bottom, left, right
                                                 'align' => 'middle' //top, bottom, left, right, middle
                                                )
                             )
                       ); 
    
    $axi_pointers->add( array(
                            'id'         => 'lotus_22_portfolio_redirect',     // Unique id for pointer
                            'hook_suffix'=> 'post.php',   // Screen hook suffix to show pointer on [empty means display every where on admin] (dashboard : index.php)
                            'target'     => '#portfolio-redirect-url', // Css selector to hang the pointer to that element
                            'version'    => '2.2',         // The theme version to display tooltip on
                            'title'      => 'New Feature',  // Tooltip title
                            'content'    => 'New option to direct user to a custom URL after clicking on portfolio item in portfolio listing page', // Tooltip description
                            'position'   =>  array( 
                                                 'edge'  => 'right',   //top, bottom, left, right
                                                 'align' => 'right' //top, bottom, left, right, middle
                                                )
                             )
                       ); 
                          
    $axi_pointers->init();
    
}

add_action("axiom_classes_loaded" , "axiom_init_custom_axiom_classes");

?>
