<?php
/**
 * Call classes here
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */


function axiom_theme_register_required_plugins(){
    /**
     * Array of plugin arrays. Required keys are name, slug and required.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
 				
 				// This is an example of how to include a plugin from the WordPress Plugin Repository
        array(
            'name'      => 'Master Slider - Responsive Touch Slider',
            'slug'      => 'master-slider',
            'required'  => false,
        ),


        // This is an example of how to include a plugin pre-packaged with a theme
        array(
            'name'                  => 'LayerSlider Responsive WordPress Slider Plugin', // The plugin name
            'slug'                  => 'LayerSlider', // The plugin slug (typically the folder name)
            'source'                => AXI_CON . 'plugins/layerslider.zip', // The plugin source
            'required'              => true, // If false, the plugin is only 'recommended' instead of required
            'version'               => '6.4.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => true,  // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),
        
        array(
            'name'                  => 'Slider Revolution Responsive WordPress Plugin', // The plugin name
            'slug'                  => 'revslider', // The plugin slug (typically the folder name)
            'source'                => AXI_CON . 'plugins/revslider.zip', // The plugin source
            'required'              => true, // If false, the plugin is only 'recommended' instead of required
            'version'               => '5.4.5', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => true, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  => 'Envato WordPress Toolkit (Theme Auto Update)', // The plugin name
            'slug'                  => 'envato-wordpress-toolkit', // The plugin slug (typically the folder name)
            'source'                => 'https://github.com/envato/envato-wordpress-toolkit/archive/master.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => 'https://github.com/envato/envato-wordpress-toolkit/', // If set, overrides default API URL and points to an external URL
        ),
 
        // This is an example of how to include a plugin from the WordPress Plugin Repository
        array(
            'name'      => 'Tweeple',
            'slug'      => 'tweeple',
            'required'  => true,
        ),
        
        array(
            'name'      => 'WordPress SEO by Yoast',
            'slug'      => 'wordpress-seo',
            'required'  => false,
        ),
        
        array(
            'name'      => 'Contact Form 7',
            'slug'      => 'contact-form-7',
            'required'  => false,
        )
    );
    
    
    // Change this to your theme text domain, used for internationalising strings
    $theme_text_domain = 'default';
 
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'id'           => $theme_text_domain,      // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false                    // Automatically activate plugins after installation or not.
    );
    
    tgmpa( apply_filters( 'axiom_theme_required_plugins', $plugins ) , $config );
}

add_action( 'tgmpa_register', 'axiom_theme_register_required_plugins' );
