<?php
/**
 * Front-end Asset Manager
 *
 * @package    Axiom
 * @author     averta
 * @copyright  Copyright (c) averta co
 * @version    Release: 1.0
 * @link       http://www.averta.net
 */


/*-----------------------------------------------------------------------------------*/
/*  Add FRONT-END styles
/*-----------------------------------------------------------------------------------*/

// Add styles in header
function axiom_enqueue_front_custom_styles(){
    global $axiom_options;
    $theme_data = wp_get_theme();
    
    
    // register front-end custom styles //////////////////////////////////////////////
    
    wp_register_style('theme-base'    , THEME_URL . 'css/base.css'                   , NULL, $theme_data->Version);
    wp_register_style('theme-main'    , THEME_URL . 'css/main.css'                   , array("theme-base"), $theme_data->Version);
    wp_register_style('superfish'     , THEME_URL . 'css/other/superfish.css'        , array("theme-base", "theme-main"), $theme_data->Version);
    wp_register_style('theme-resp'    , THEME_URL . 'css/responsive.css'             , array("theme-base", "theme-main", "superfish"), $theme_data->Version);
    wp_register_style('theme-rtl'     , THEME_URL . 'css/rtl.css'                    , array("theme-base", "theme-main", "superfish"), $theme_data->Version);
    wp_register_style('theme-fonts'   , THEME_URL . 'css/fonts.css'                  , array("theme-base", "theme-main", "superfish"), $theme_data->Version);
    wp_register_style('theme-stylesheet', get_stylesheet_uri()                       , array("theme-base", "theme-main", "superfish"), $theme_data->Version);
    
    
    
    
    wp_register_style('prettyPhoto'   , THEME_URL . 'css/other/prettyPhoto.css'      , NULL, '3.2');
    wp_register_style('jplayer'       , THEME_URL . 'css/other/jplayer/jplayer.css'  , NULL, '3.2');
    wp_register_style('flexslider'    , THEME_URL . 'css/other/flexslider.css'       , NULL, '1.0');
    wp_register_style('nivoslider'    , THEME_URL . 'css/other/nivoslider.css'       , NULL, '3.1');
    wp_register_style('highlightjs'   , THEME_URL . 'css/other/highlightjs/googlecode.css'  , NULL, '7.2');
    wp_register_style('userdefined'   , THEME_URL . 'css/other/custom.css'           , NULL, $GLOBALS[THEME_ID."_custom_css_ver"]);
    
    
    // Enqueue front-end custom styles //////////////////////////////////////////////
    
    // enqueue styles
    wp_enqueue_style ('theme-base');
    wp_enqueue_style ('theme-main');
    wp_enqueue_style ('superfish');
    if(isset($axiom_options["enable_site_reponsiveness"])) { wp_enqueue_style ('theme-resp'); }
    
    // (defined('ICL_LANGUAGE_CODE') && ICL_LANGUAGE_CODE == "something")
    if(is_rtl()) { wp_enqueue_style ('theme-rtl'); }
    
    wp_enqueue_style('theme-fonts');
    wp_enqueue_style('theme-stylesheet');
    wp_enqueue_style('prettyPhoto');
    wp_enqueue_style('jplayer');
    
    // load custom.css if the directory is writable. else use inline css fallback
    $inline_css = get_option( 'axiom_'.THEME_ID.'_custom_CSS_options');
    if(empty($inline_css))
        wp_enqueue_style ('userdefined');
    
    // load custom google fonts
    wp_enqueue_style ('custom_typography');
    
    
}
add_action('wp_enqueue_scripts', 'axiom_enqueue_front_custom_styles');


/*-----------------------------------------------------------------------------------*/
/*  Add FRONT-END Scripts
/*-----------------------------------------------------------------------------------*/


function axiom_enqueue_front_custom_scripts(){
    
    // register front-end custom scripts /////////////////////////////////////////////
    
    wp_deregister_script("jquery");
    //wp_register_script('jquery'       , 'http' . ($_SERVER['SERVER_PORT'] == 443 ? 's' : '') . '://ajax.googleapis.com/ajax/libs/jquery/1/jquery.min.js');
    wp_register_script('jquery'        , THEME_URL . 'js/libs/jquery-1.9.1.min.js');
    
    //wp_register_script('jquery-migrate', 'http' . ($_SERVER['SERVER_PORT'] == 443 ? 's' : '') . '://code.jquery.com/jquery-migrate-1.0.0.js', array('jquery'), '1.0');
    //wp_enqueue_script ('jquery-migrate');
    
    // create essential js global vars
    $axi_upload_dir = wp_upload_dir();
    wp_localize_script( 'jquery', 'axiom', array(   'is_rtl'    => is_rtl() ,
                                                    'wpml_lang' =>  defined('ICL_LANGUAGE_CODE')?ICL_LANGUAGE_CODE:"en",
                                                    'uploadbaseurl' => $axi_upload_dir['baseurl'] ) );
    
    wp_register_script('debouncedresize',THEME_URL . 'js/libs/plugins/jquery.debouncedresize.js' , array('jquery'), '1.0', TRUE);
    
    wp_register_script('axi_essentials',THEME_URL . 'js/plugins.js' , array('jquery'), '1.6', TRUE);
    
    wp_deregister_script('hoverIntent');
    wp_register_script('hoverIntent'  , THEME_URL . 'js/libs/hoverIntent.js' , array('jquery'), "r7", TRUE);
    
    wp_register_script('superfish'    , THEME_URL . 'js/libs/superfish.js'   , array('jquery','hoverIntent'), '1.7.2', TRUE);
    
    wp_register_script('flexslider_dc', THEME_URL . 'js/libs/modules/jquery.flexslider.manualDirectionControls.js' , array('jquery', 'flexslider'), NULL, TRUE);
    wp_register_script('flexslider'   , THEME_URL . 'js/libs/modules/jquery.flexslider-min.js'   , array('jquery', 'jquery_easing'), '2.1', TRUE);
    
    wp_register_script('nivoslider'   , THEME_URL . 'js/libs/modules/jquery.nivo.slider.pack.js' , array('jquery'), '3.2', TRUE);
    
    wp_register_script('jquery_easing', THEME_URL . 'js/libs/plugins/jquery.easing.min.js'  , array('jquery'), '1.3');
    
    wp_register_script('prettyPhoto'  , THEME_URL . 'js/libs/plugins/jquery.prettyPhoto.js' , array('jquery'), '3.1.5', TRUE);
    
    wp_register_script('jplayer'      , THEME_URL . 'js/libs/plugins/jquery.jplayer/jquery.jplayer.js' , array('jquery'), '2.2');
    wp_register_script('fitvids'      , THEME_URL . 'js/libs/plugins/jquery.fitvids.js'     , array('jquery'), '1.0', TRUE);
    
    wp_register_script('isotope'      , THEME_URL . 'js/libs/plugins/jquery.isotope.min.js' , array('jquery', 'axi_essentials'), '1.5.25', TRUE);
    
    wp_register_script('touchswipe'   , THEME_URL . 'js/libs/plugins/jquery.touchSwipe.min.js' , array('jquery'), '1.3.3', TRUE);
    wp_register_script('mousewheel'   , THEME_URL . 'js/libs/plugins/jquery.mousewheel.min.js' , array('jquery'), '3.0.6', TRUE);
    
    wp_register_script('caroufredsel' , THEME_URL . 'js/libs/plugins/jquery.carouFredSel-6.1.0-packed.js' , array('jquery', 'touchswipe', 'mousewheel', 'jquery_easing'), '6.1.0', TRUE);
    
    wp_register_script('mapapi'       , 'http://maps.google.com/maps/api/js?sensor=false', null, null, TRUE);
    wp_register_script('gomap'        , THEME_URL . 'js/libs/plugins/jquery.gomap-1.3.2.min.js', array('jquery', 'mapapi'), '1.3.2', TRUE);
    
    //wp_register_script('minitwitter'  , THEME_URL . 'js/libs/plugins/jquery.minitwitter.js', array('jquery'), '1.0', TRUE);
    
    wp_register_script('highlightjs'  , THEME_URL . 'js/libs/modules/highlight.pack.js', null, '7.2', TRUE);
    
    wp_register_script('axi.src'      , THEME_URL . 'js/script.js' , array('jquery', 'axi_essentials'), '1.8', TRUE);
    
    
    // register axi plugins
    wp_register_script('axi.accordion', THEME_URL . 'js/libs/plugins/averta.accordion.js' , array('jquery'), '1.22', TRUE);
    
    
    // register custom scripts
    wp_register_script('init.faq.accordion'  , THEME_URL . 'js/src/init.faq.js' , array('jquery','axi.accordion' ), null, TRUE);
    
    
    
    
    
    // Enqueue front-end custom scripts /////////////////////////////////////////////
    
    wp_enqueue_script ('jquery');
    wp_enqueue_script ('axi_essentials');
    wp_enqueue_script ('superfish');
    wp_enqueue_script ('prettyPhoto');
    wp_enqueue_script ('fitvids');
    
    wp_enqueue_script ('isotope');
    wp_enqueue_script ('caroufredsel');
    wp_enqueue_script ('axi.src');
    
}
add_action('wp_enqueue_scripts', 'axiom_enqueue_front_custom_scripts');

/*-----------------------------------------------------------------------------------*/
