<?php
/**
 * Admin hooks
 *
 * 
 * @package    auxin
 * @author     averta (c) 2010-2016
 * @link       http://averta.net

*/
function auxin_update_font_icons_list(){
    // parse and cache the list of fonts
    $fonts = Auxin()->font_icons;
    $fonts->update();
}
add_action( 'after_setup_theme', 'auxin_update_font_icons_list' );


// make the customizer avaialble while requesting via ajax
if ( defined('DOING_AJAX') && DOING_AJAX ){
    Auxin_Customizer::get_instance();
}


global $pagenow;
// redirect to welcome page after theme activation
if ( isset( $_GET['activated'] ) && $pagenow == "themes.php"){
    wp_redirect( admin_url('themes.php?page=auxin-welcome&about=1') );
}


/*-----------------------------------------------------------------------------------*/
/*  Include the Welcome page
/*-----------------------------------------------------------------------------------*/

function auxin_register_theme_menu() {

    $root_menu_name = AUXIN_NO_BRAND ? __( 'Theme Setting', 'phlox') : THEME_NAME_I18N;
    $root_menu_name = apply_filters( 'auxin_theme_setting_menu_name', $root_menu_name );

    $welcome_root_slug = 'auxin-welcome';

    //

    /*  Register welcome sumenu
    /*------------------------------------------------------------------------*/
    add_theme_page(
        __('Welcome', 'phlox'),                    // [Title]    The title to be displayed on the corresponding page for this menu
        $root_menu_name,                                // [Text]     The text to be displayed for this actual menu item
        apply_filters( 'auxin_theme_welcome_featured_capability', 'manage_options' ),
                                                        // [User]     Which type of users can see this menu
        $welcome_root_slug,                             // [ID/slug]  The unique ID - that is, the slug - for this menu item
        array( Auxin_About::get_instance(), 'render')   // [Callback] The name of the function to call when rendering the menu for this page
    );
}

add_action( 'admin_menu', 'auxin_register_theme_menu' );
