<?php
/**
 * Adding options and capabilities while theme is installed
 *
 * 
 * @package    auxin
 * @author     averta (c) 2010-2016
 * @link       http://averta.net

*/

// no direct access allowed
if ( ! defined('ABSPATH') )  exit;



class Auxin_Install {

  function __construct(){

    // Add theme capabilities on theme activation
    add_action( 'after_switch_theme', array( $this, 'install' ) );
  }


  /**
   * Install theme requirements
   */
  public function install(){
    $this->add_capabilities();
  }


  /**
   * Add theme custom capabilities
   */
  public function add_capabilities() {
    global $wp_roles;

    if ( class_exists( 'WP_Roles' ) ) {
      if ( ! isset( $wp_roles ) ) {
        $wp_roles = new WP_Roles();
      }
    }

    if ( is_object( $wp_roles ) ) {

      $capabilities = $this->get_theme_capabilities();

      foreach ( $capabilities as $cap_group ) {
        foreach ( $cap_group as $cap ) {
          $wp_roles->add_cap( 'administrator', $cap );
          $wp_roles->add_cap( 'editor'     , $cap );
        }
      }
    }


    // check if custom capabilities are added before or not
    $is_added = get_option( 'auxin_capabilities_added', 0 );

    update_option( 'auxin_capabilities_added', 1 );
  }



  /**
   * Get capabilities for auxin - Will be assigned during theme activation
   *
   * @return array
   */
  public function get_theme_capabilities() {

    $capabilities      = array();
    $active_post_types = auxin_get_possible_post_types(true);


    foreach ( $active_post_types as $post_type => $is_active ) {

      $capabilities[ $post_type ] = array(
        // Post type
        "edit_{$post_type}",
        "read_{$post_type}",
        "delete_{$post_type}",
        "edit_{$post_type}s",
        "edit_others_{$post_type}s",
        "publish_{$post_type}s",
        "read_private_{$post_type}s",
        "delete_{$post_type}s",
        "delete_private_{$post_type}s",
        "delete_published_{$post_type}s",
        "delete_others_{$post_type}s",
        "edit_private_{$post_type}s",
        "edit_published_{$post_type}s",

        // Terms
        "manage_{$post_type}_terms",
        "edit_{$post_type}_terms",
        "delete_{$post_type}_terms",
        "assign_{$post_type}_terms"
      );
    }

    return $capabilities;
  }

}

